/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.testplan.cases.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.testplan.cases.model.TestPlan;
import io.tiklab.teston.testplan.cases.model.TestPlanQuery;
import io.tiklab.teston.testplan.cases.service.TestPlanService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/testPlan"})
@Api(name="TestPlanController", desc="\u6d4b\u8bd5\u8ba1\u5212")
public class TestPlanController {
    private static Logger logger = LoggerFactory.getLogger(TestPlanController.class);
    @Autowired
    private TestPlanService testPlanService;

    @RequestMapping(path={"/createTestPlan"}, method={RequestMethod.POST})
    @ApiMethod(name="createTestPlan", desc="\u521b\u5efa\u6d4b\u8bd5i\u8ba1\u5212")
    @ApiParam(name="testPlan", desc="testPlan", required=true)
    public Result<String> createTestPlan(@RequestBody @NotNull @Valid TestPlan testPlan) {
        String id = this.testPlanService.createTestPlan(testPlan);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateTestPlan"}, method={RequestMethod.POST})
    @ApiMethod(name="updateTestPlan", desc="\u4fee\u6539\u6d4b\u8bd5\u8ba1\u5212")
    @ApiParam(name="testPlan", desc="testPlan", required=true)
    public Result<Void> updateTestPlan(@RequestBody @NotNull @Valid TestPlan testPlan) {
        this.testPlanService.updateTestPlan(testPlan);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteTestPlan"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteTestPlan", desc="\u901a\u8fc7id\u5220\u9664\u6d4b\u8bd5\u8ba1\u5212")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteTestPlan(@NotNull String id) {
        this.testPlanService.deleteTestPlan(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findTestPlan"}, method={RequestMethod.POST})
    @ApiMethod(name="findTestPlan", desc="\u901a\u8fc7id\u67e5\u8be2\u6d4b\u8bd5\u8ba1\u5212")
    @ApiParam(name="id", desc="id", required=true)
    public Result<TestPlan> findTestPlan(@NotNull String id) {
        TestPlan testPlan = this.testPlanService.findTestPlan(id);
        return Result.ok((Object)testPlan);
    }

    @RequestMapping(path={"/findAllTestPlan"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllTestPlan", desc="\u67e5\u8be2\u6240\u6709\u6d4b\u8bd5\u8ba1\u5212")
    public Result<List<TestPlan>> findAllTestPlan() {
        List testPlanList = this.testPlanService.findAllTestPlan();
        return Result.ok((Object)testPlanList);
    }

    @RequestMapping(path={"/findTestPlanList"}, method={RequestMethod.POST})
    @ApiMethod(name="findTestPlanList", desc="\u901a\u8fc7\u67e5\u8be2\u5bf9\u8c61\u67e5\u8be2\u6d4b\u8bd5\u8ba1\u5212")
    @ApiParam(name="testPlanQuery", desc="testPlanQuery", required=true)
    public Result<List<TestPlan>> findTestPlanList(@RequestBody @Valid @NotNull TestPlanQuery testPlanQuery) {
        List testPlanList = this.testPlanService.findTestPlanList(testPlanQuery);
        return Result.ok((Object)testPlanList);
    }

    @RequestMapping(path={"/findTestPlanPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findTestPlanPage", desc="\u901a\u8fc7\u67e5\u8be2\u5bf9\u8c61\u5206\u9875\u67e5\u8be2\u6d4b\u8bd5\u8ba1\u5212")
    @ApiParam(name="testPlanQuery", desc="testPlanQuery", required=true)
    public Result<Pagination<TestPlan>> findTestPlanPage(@RequestBody @Valid @NotNull TestPlanQuery testPlanQuery) {
        Pagination pagination = this.testPlanService.findTestPlanPage(testPlanQuery);
        return Result.ok((Object)pagination);
    }
}

