/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.web.scene.instance.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.web.scene.execute.model.WebSceneTestResponse;
import io.tiklab.teston.test.web.scene.instance.dao.WebSceneInstanceDao;
import io.tiklab.teston.test.web.scene.instance.entity.WebSceneInstanceEntity;
import io.tiklab.teston.test.web.scene.instance.model.WebSceneInstance;
import io.tiklab.teston.test.web.scene.instance.model.WebSceneInstanceQuery;
import io.tiklab.teston.test.web.scene.instance.model.WebSceneInstanceStep;
import io.tiklab.teston.test.web.scene.instance.model.WebSceneInstanceStepQuery;
import io.tiklab.teston.test.web.scene.instance.service.WebSceneInstanceService;
import io.tiklab.teston.test.web.scene.instance.service.WebSceneInstanceStepService;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebSceneInstanceServiceImpl
implements WebSceneInstanceService {
    @Autowired
    WebSceneInstanceDao webSceneInstanceDao;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    WebSceneInstanceStepService webSceneInstanceStepService;

    public String createWebSceneInstance(@NotNull @Valid WebSceneInstance webSceneInstance) {
        WebSceneInstanceEntity webSceneInstanceEntity = (WebSceneInstanceEntity)BeanMapper.map((Object)webSceneInstance, WebSceneInstanceEntity.class);
        webSceneInstanceEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return this.webSceneInstanceDao.createWebSceneInstance(webSceneInstanceEntity);
    }

    public void updateWebSceneInstance(@NotNull @Valid WebSceneInstance webSceneInstance) {
        WebSceneInstanceEntity webSceneInstanceEntity = (WebSceneInstanceEntity)BeanMapper.map((Object)webSceneInstance, WebSceneInstanceEntity.class);
        this.webSceneInstanceDao.updateWebSceneInstance(webSceneInstanceEntity);
    }

    public void deleteWebSceneInstance(@NotNull String id) {
        this.webSceneInstanceDao.deleteWebSceneInstance(id);
    }

    public WebSceneInstance findOne(String id) {
        WebSceneInstanceEntity webSceneInstanceEntity = this.webSceneInstanceDao.findWebSceneInstance(id);
        WebSceneInstance webSceneInstance = (WebSceneInstance)BeanMapper.map((Object)webSceneInstanceEntity, WebSceneInstance.class);
        return webSceneInstance;
    }

    public List<WebSceneInstance> findList(List<String> idList) {
        List<WebSceneInstanceEntity> webSceneInstanceEntityList = this.webSceneInstanceDao.findWebSceneInstanceList(idList);
        List webSceneInstanceList = BeanMapper.mapList(webSceneInstanceEntityList, WebSceneInstance.class);
        return webSceneInstanceList;
    }

    public WebSceneInstance findWebSceneInstance(@NotNull String id) {
        WebSceneInstance webSceneInstance = this.findOne(id);
        List webSceneInstanceStepList = this.webSceneInstanceStepService.findWebSceneInstanceStepList(new WebSceneInstanceStepQuery().setWebSceneInstanceId(id));
        webSceneInstance.setStepList(webSceneInstanceStepList);
        this.joinTemplate.joinQuery((Object)webSceneInstance);
        return webSceneInstance;
    }

    public List<WebSceneInstance> findAllWebSceneInstance() {
        List<WebSceneInstanceEntity> webSceneInstanceEntities = this.webSceneInstanceDao.findAllWebSceneInstance();
        List webSceneInstanceList = BeanMapper.mapList(webSceneInstanceEntities, WebSceneInstance.class);
        this.joinTemplate.joinQuery(webSceneInstanceList);
        return webSceneInstanceList;
    }

    public List<WebSceneInstance> findWebSceneInstanceList(WebSceneInstanceQuery webSceneInstanceQuery) {
        List<WebSceneInstanceEntity> webSceneInstanceEntities = this.webSceneInstanceDao.findWebSceneInstanceList(webSceneInstanceQuery);
        List webSceneInstanceList = BeanMapper.mapList(webSceneInstanceEntities, WebSceneInstance.class);
        this.joinTemplate.joinQuery(webSceneInstanceList);
        return webSceneInstanceList;
    }

    public Pagination<WebSceneInstance> findWebSceneInstancePage(WebSceneInstanceQuery webSceneInstanceQuery) {
        Pagination<WebSceneInstanceEntity> pagination = this.webSceneInstanceDao.findWebSceneInstancePage(webSceneInstanceQuery);
        List webSceneInstanceList = BeanMapper.mapList((List)pagination.getDataList(), WebSceneInstance.class);
        this.joinTemplate.joinQuery(webSceneInstanceList);
        return PaginationBuilder.build(pagination, (List)webSceneInstanceList);
    }

    public String saveWebSceneInstanceToSql(WebSceneInstance webSceneInstance, WebSceneTestResponse webSceneTestResponse) {
        String webSceneInstanceId = this.createWebSceneInstance(webSceneInstance);
        if (CollectionUtils.isNotEmpty((Collection)webSceneTestResponse.getWebUnitResultList())) {
            for (WebSceneInstanceStep webSceneInstanceStep : webSceneTestResponse.getWebUnitResultList()) {
                webSceneInstanceStep.setWebSceneInstanceId(webSceneInstanceId);
                this.webSceneInstanceStepService.createWebSceneInstanceStep(webSceneInstanceStep);
            }
        }
        return webSceneInstanceId;
    }
}

