/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.web.scene.instance.dao;

import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.dal.jpa.criterial.condition.DeleteCondition;
import io.tiklab.dal.jpa.criterial.condition.QueryCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.QueryBuilders;
import io.tiklab.teston.test.web.scene.instance.entity.WebSceneInstanceEntity;
import io.tiklab.teston.test.web.scene.instance.model.WebSceneInstanceQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class WebSceneInstanceDao {
    private static Logger logger = LoggerFactory.getLogger(WebSceneInstanceDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createWebSceneInstance(WebSceneInstanceEntity webSceneInstanceEntity) {
        return (String)this.jpaTemplate.save((Object)webSceneInstanceEntity, String.class);
    }

    public void updateWebSceneInstance(WebSceneInstanceEntity webSceneInstanceEntity) {
        this.jpaTemplate.update((Object)webSceneInstanceEntity);
    }

    public void deleteWebSceneInstance(String id) {
        this.jpaTemplate.delete(WebSceneInstanceEntity.class, (Object)id);
    }

    public void deleteWebSceneInstance(DeleteCondition deleteCondition) {
        this.jpaTemplate.delete(deleteCondition);
    }

    public WebSceneInstanceEntity findWebSceneInstance(String id) {
        return (WebSceneInstanceEntity)this.jpaTemplate.findOne(WebSceneInstanceEntity.class, (Object)id);
    }

    public List<WebSceneInstanceEntity> findAllWebSceneInstance() {
        return this.jpaTemplate.findAll(WebSceneInstanceEntity.class);
    }

    public List<WebSceneInstanceEntity> findWebSceneInstanceList(List<String> idList) {
        return this.jpaTemplate.findList(WebSceneInstanceEntity.class, idList);
    }

    public List<WebSceneInstanceEntity> findWebSceneInstanceList(WebSceneInstanceQuery webSceneInstanceQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(WebSceneInstanceEntity.class).eq("webSceneId", (Object)webSceneInstanceQuery.getWebSceneId()).orders(webSceneInstanceQuery.getOrderParams()).get();
        return this.jpaTemplate.findList(queryCondition, WebSceneInstanceEntity.class);
    }

    public Pagination<WebSceneInstanceEntity> findWebSceneInstancePage(WebSceneInstanceQuery webSceneInstanceQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(WebSceneInstanceEntity.class).eq("webSceneId", (Object)webSceneInstanceQuery.getWebSceneId()).pagination(webSceneInstanceQuery.getPageParam()).orders(webSceneInstanceQuery.getOrderParams()).get();
        return this.jpaTemplate.findPage(queryCondition, WebSceneInstanceEntity.class);
    }
}

