/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.web.scene.instance.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.test.web.scene.instance.model.WebSceneInstance;
import io.tiklab.teston.test.web.scene.instance.model.WebSceneInstanceQuery;
import io.tiklab.teston.test.web.scene.instance.service.WebSceneInstanceService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/webSceneInstance"})
@Api(name="WebSceneInstanceController", desc="web\u573a\u666f\u6d4b\u8bd5\u5b9e\u4f8b")
public class WebSceneInstanceController {
    private static Logger logger = LoggerFactory.getLogger(WebSceneInstanceController.class);
    @Autowired
    private WebSceneInstanceService webSceneInstanceService;

    @RequestMapping(path={"/createWebSceneInstance"}, method={RequestMethod.POST})
    @ApiMethod(name="createWebSceneInstance", desc="\u521b\u5efaweb\u573a\u666f\u5b9e\u4f8b")
    @ApiParam(name="webSceneInstance", desc="webSceneInstance", required=true)
    public Result<String> createWebSceneInstance(@RequestBody @NotNull @Valid WebSceneInstance webSceneInstance) {
        String id = this.webSceneInstanceService.createWebSceneInstance(webSceneInstance);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateWebSceneInstance"}, method={RequestMethod.POST})
    @ApiMethod(name="updateWebSceneInstance", desc="\u66f4\u65b0web\u573a\u666f\u5b9e\u4f8b")
    @ApiParam(name="webSceneInstance", desc="webSceneInstance", required=true)
    public Result<Void> updateWebSceneInstance(@RequestBody @NotNull @Valid WebSceneInstance webSceneInstance) {
        this.webSceneInstanceService.updateWebSceneInstance(webSceneInstance);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteWebSceneInstance"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteWebSceneInstance", desc="\u5220\u9664web\u573a\u666f\u5b9e\u4f8b")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteWebSceneInstance(@NotNull String id) {
        this.webSceneInstanceService.deleteWebSceneInstance(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findWebSceneInstance"}, method={RequestMethod.POST})
    @ApiMethod(name="findWebSceneInstance", desc="\u6839\u636eid\u67e5\u627eweb\u573a\u666f\u5b9e\u4f8b")
    @ApiParam(name="id", desc="id", required=true)
    public Result<WebSceneInstance> findWebSceneInstance(@NotNull String id) {
        WebSceneInstance webSceneInstance = this.webSceneInstanceService.findWebSceneInstance(id);
        return Result.ok((Object)webSceneInstance);
    }

    @RequestMapping(path={"/findAllWebSceneInstance"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllWebSceneInstance", desc="\u67e5\u627e\u6240\u6709web\u573a\u666f\u5b9e\u4f8b")
    public Result<List<WebSceneInstance>> findAllWebSceneInstance() {
        List allWebSceneInstance = this.webSceneInstanceService.findAllWebSceneInstance();
        return Result.ok((Object)allWebSceneInstance);
    }

    @RequestMapping(path={"/findWebSceneInstanceList"}, method={RequestMethod.POST})
    @ApiMethod(name="findWebSceneInstanceList", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u67e5\u8be2web\u573a\u666f\u5b9e\u4f8b\u5217\u8868")
    @ApiParam(name="webSceneInstanceQuery", desc="webSceneInstanceQuery", required=true)
    public Result<List<WebSceneInstance>> findWebSceneInstanceList(@RequestBody @Valid @NotNull WebSceneInstanceQuery webSceneInstanceQuery) {
        List webSceneInstanceList = this.webSceneInstanceService.findWebSceneInstanceList(webSceneInstanceQuery);
        return Result.ok((Object)webSceneInstanceList);
    }

    @RequestMapping(path={"/findWebSceneInstancePage"}, method={RequestMethod.POST})
    @ApiMethod(name="findWebSceneInstancePage", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u6309\u5206\u9875\u67e5\u8be2web\u573a\u666f\u5b9e\u4f8b")
    @ApiParam(name="webSceneInstanceQuery", desc="webSceneInstanceQuery", required=true)
    public Result<Pagination<WebSceneInstance>> findWebSceneInstancePage(@RequestBody @Valid @NotNull WebSceneInstanceQuery webSceneInstanceQuery) {
        Pagination pagination = this.webSceneInstanceService.findWebSceneInstancePage(webSceneInstanceQuery);
        return Result.ok((Object)pagination);
    }
}

