/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.web.scene.execute.service;

import io.tiklab.rpc.client.router.lookup.FixedLookup;
import io.tiklab.rpc.client.router.lookup.Lookup;
import io.tiklab.teston.agent.web.scene.WebSceneTestService;
import io.tiklab.teston.support.agentconfig.model.AgentConfig;
import io.tiklab.teston.support.agentconfig.model.AgentConfigQuery;
import io.tiklab.teston.support.agentconfig.service.AgentConfigService;
import io.tiklab.teston.test.web.scene.cases.model.WebSceneStepQuery;
import io.tiklab.teston.test.web.scene.cases.service.WebSceneStepService;
import io.tiklab.teston.test.web.scene.execute.model.WebSceneTestRequest;
import io.tiklab.teston.test.web.scene.execute.model.WebSceneTestResponse;
import io.tiklab.teston.test.web.scene.execute.service.WebSceneTestDispatchService;
import io.tiklab.teston.test.web.scene.instance.model.WebSceneInstance;
import io.tiklab.teston.test.web.scene.instance.model.WebSceneInstanceQuery;
import io.tiklab.teston.test.web.scene.instance.service.WebSceneInstanceService;
import io.tiklab.teston.test.web.scene.instance.service.WebSceneInstanceStepService;
import io.tiklab.teston.test.web.utils.RpcClientWebUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WebSceneTestDispatchServiceImpl
implements WebSceneTestDispatchService {
    @Autowired
    WebSceneStepService webSceneStepService;
    @Autowired
    WebSceneInstanceService webSceneInstanceService;
    @Autowired
    WebSceneInstanceStepService webSceneInstanceStepService;
    @Autowired
    AgentConfigService agentConfigService;
    @Autowired
    RpcClientWebUtil rpcClientWebUtil;
    @Autowired
    WebSceneTestService webSceneTestService;
    @Value(value="${teston-agent.embbed.enable:false}")
    Boolean enable;
    private AgentConfig agentConfig = null;
    private Integer status;

    WebSceneTestService webSceneTestServiceRPC(String agentUrl) {
        return (WebSceneTestService)this.rpcClientWebUtil.rpcClient().getBean(WebSceneTestService.class, (Lookup)new FixedLookup(agentUrl));
    }

    public Integer execute(WebSceneTestRequest webSceneTestRequest) {
        String webSceneId = webSceneTestRequest.getWebSceneId();
        WebSceneStepQuery webSceneStepQuery = new WebSceneStepQuery();
        webSceneStepQuery.setWebSceneId(webSceneId);
        List webSceneStepList = this.webSceneStepService.findWebSceneStepList(webSceneStepQuery);
        webSceneTestRequest.setWebSceneStepList(webSceneStepList);
        if (this.enable.booleanValue()) {
            this.webSceneTestService.execute(webSceneTestRequest);
        } else {
            List agentConfigList = this.agentConfigService.findAgentConfigList(new AgentConfigQuery());
            if (CollectionUtils.isNotEmpty((Collection)agentConfigList)) {
                this.agentConfig = (AgentConfig)agentConfigList.get(0);
                this.webSceneTestServiceRPC(this.agentConfig.getUrl()).execute(webSceneTestRequest);
            }
        }
        this.status = 1;
        return this.status;
    }

    public Integer status() {
        if (this.enable.booleanValue()) {
            this.status = this.webSceneTestService.status();
        } else {
            List agentConfigList = this.agentConfigService.findAgentConfigList(new AgentConfigQuery());
            if (CollectionUtils.isNotEmpty((Collection)agentConfigList)) {
                this.agentConfig = (AgentConfig)agentConfigList.get(0);
                this.status = this.webSceneTestServiceRPC(this.agentConfig.getUrl()).status();
            }
        }
        return this.status;
    }

    public WebSceneTestResponse result(WebSceneTestRequest webSceneTestRequest) {
        WebSceneTestResponse webSceneTestResponse = this.enable != false ? this.webSceneTestService.result() : this.webSceneTestServiceRPC(this.agentConfig.getUrl()).result();
        this.saveToSql(webSceneTestResponse, webSceneTestRequest.getWebSceneId());
        return webSceneTestResponse;
    }

    private void saveToSql(WebSceneTestResponse webSceneTestResponse, String webSceneId) {
        WebSceneInstance webSceneInstance = webSceneTestResponse.getWebSceneInstance();
        webSceneInstance.setWebSceneId(webSceneId);
        WebSceneInstanceQuery webSceneInstanceQuery = new WebSceneInstanceQuery();
        webSceneInstanceQuery.setWebSceneId(webSceneId);
        List webSceneInstanceList = this.webSceneInstanceService.findWebSceneInstanceList(webSceneInstanceQuery);
        if (webSceneInstanceList != null && webSceneInstanceList.size() > 0) {
            Integer executeNumber = ((WebSceneInstance)webSceneInstanceList.get(0)).getExecuteNumber();
            executeNumber = executeNumber + 1;
            webSceneInstance.setExecuteNumber(executeNumber);
        } else {
            webSceneInstance.setExecuteNumber(Integer.valueOf(1));
        }
        this.webSceneInstanceService.saveWebSceneInstanceToSql(webSceneInstance, webSceneTestResponse);
    }
}

