/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.web.scene.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.web.scene.cases.dao.WebSceneStepDao;
import io.tiklab.teston.test.web.scene.cases.entity.WebSceneStepEntity;
import io.tiklab.teston.test.web.scene.cases.model.WebSceneStep;
import io.tiklab.teston.test.web.scene.cases.model.WebSceneStepQuery;
import io.tiklab.teston.test.web.scene.cases.service.WebSceneStepService;
import java.sql.Timestamp;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebSceneStepServiceImpl
implements WebSceneStepService {
    @Autowired
    WebSceneStepDao webSceneStepDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createWebSceneStep(@NotNull @Valid WebSceneStep webSceneStep) {
        WebSceneStepEntity webSceneStepEntity = (WebSceneStepEntity)BeanMapper.map((Object)webSceneStep, WebSceneStepEntity.class);
        webSceneStepEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return this.webSceneStepDao.createWebSceneStep(webSceneStepEntity);
    }

    public void updateWebSceneStep(@NotNull @Valid WebSceneStep webSceneStep) {
        WebSceneStepEntity webSceneStepEntity = (WebSceneStepEntity)BeanMapper.map((Object)webSceneStep, WebSceneStepEntity.class);
        this.webSceneStepDao.updateWebSceneStep(webSceneStepEntity);
    }

    public void deleteWebSceneStep(@NotNull String id) {
        this.webSceneStepDao.deleteWebSceneStep(id);
    }

    public WebSceneStep findOne(String id) {
        WebSceneStepEntity webSceneStepEntity = this.webSceneStepDao.findWebSceneStep(id);
        WebSceneStep webSceneStep = (WebSceneStep)BeanMapper.map((Object)webSceneStepEntity, WebSceneStep.class);
        return webSceneStep;
    }

    public List<WebSceneStep> findList(List<String> idList) {
        List<WebSceneStepEntity> webSceneStepEntityList = this.webSceneStepDao.findWebSceneStepList(idList);
        List webSceneStepList = BeanMapper.mapList(webSceneStepEntityList, WebSceneStep.class);
        return webSceneStepList;
    }

    public WebSceneStep findWebSceneStep(@NotNull String id) {
        WebSceneStep webSceneStep = this.findOne(id);
        this.joinTemplate.joinQuery((Object)webSceneStep);
        return webSceneStep;
    }

    public List<WebSceneStep> findAllWebSceneStep() {
        List<WebSceneStepEntity> webSceneStepEntityList = this.webSceneStepDao.findAllWebSceneStep();
        List webSceneStepList = BeanMapper.mapList(webSceneStepEntityList, WebSceneStep.class);
        this.joinTemplate.joinQuery(webSceneStepList);
        return webSceneStepList;
    }

    public List<WebSceneStep> findWebSceneStepList(WebSceneStepQuery webSceneStepQuery) {
        List<WebSceneStepEntity> webSceneStepEntityList = this.webSceneStepDao.findWebSceneStepList(webSceneStepQuery);
        List webSceneStepList = BeanMapper.mapList(webSceneStepEntityList, WebSceneStep.class);
        this.joinTemplate.joinQuery(webSceneStepList);
        return webSceneStepList;
    }

    public Pagination<WebSceneStep> findWebSceneStepPage(WebSceneStepQuery webSceneStepQuery) {
        Pagination<WebSceneStepEntity> pagination = this.webSceneStepDao.findWebSceneStepPage(webSceneStepQuery);
        List webSceneStepList = BeanMapper.mapList((List)pagination.getDataList(), WebSceneStep.class);
        this.joinTemplate.joinQuery(webSceneStepList);
        return PaginationBuilder.build(pagination, (List)webSceneStepList);
    }
}

