/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.web.scene.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.category.model.Category;
import io.tiklab.teston.category.service.CategoryService;
import io.tiklab.teston.test.test.model.TestCase;
import io.tiklab.teston.test.test.model.TestCaseQuery;
import io.tiklab.teston.test.test.service.TestCaseService;
import io.tiklab.teston.test.web.scene.cases.dao.WebSceneCaseDao;
import io.tiklab.teston.test.web.scene.cases.entity.WebSceneCaseEntity;
import io.tiklab.teston.test.web.scene.cases.model.WebSceneCase;
import io.tiklab.teston.test.web.scene.cases.model.WebSceneCaseQuery;
import io.tiklab.teston.test.web.scene.cases.service.WebSceneCaseService;
import io.tiklab.user.user.model.User;
import io.tiklab.user.user.service.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class WebSceneCaseServiceImpl
implements WebSceneCaseService {
    @Autowired
    WebSceneCaseDao webSceneCaseDao;
    @Autowired
    TestCaseService testCaseService;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    CategoryService categoryService;
    @Autowired
    UserService userService;

    public String createWebSceneCase(@NotNull @Valid WebSceneCase webSceneCase) {
        WebSceneCaseEntity webSceneCaseEntity = (WebSceneCaseEntity)BeanMapper.map((Object)webSceneCase, WebSceneCaseEntity.class);
        String id = this.webSceneCaseDao.createWebSceneCase(webSceneCaseEntity);
        webSceneCaseEntity.setTestCaseId(id);
        webSceneCaseEntity.setId(id);
        this.webSceneCaseDao.updateWebSceneCase(webSceneCaseEntity);
        TestCase testCase = webSceneCase.getTestCase();
        testCase.setId(id);
        this.testCaseService.createTestCase(testCase);
        return id;
    }

    public void updateWebSceneCase(@NotNull @Valid WebSceneCase webSceneCase) {
        WebSceneCaseEntity webSceneCaseEntity = (WebSceneCaseEntity)BeanMapper.map((Object)webSceneCase, WebSceneCaseEntity.class);
        this.webSceneCaseDao.updateWebSceneCase(webSceneCaseEntity);
        this.testCaseService.updateTestCase(webSceneCase.getTestCase());
    }

    public void deleteWebSceneCase(@NotNull String id) {
        this.webSceneCaseDao.deleteWebSceneCase(id);
        this.testCaseService.deleteTestCase(id);
    }

    public WebSceneCase findOne(String id) {
        WebSceneCaseEntity webSceneCaseEntity = this.webSceneCaseDao.findWebSceneCase(id);
        WebSceneCase webSceneCase = (WebSceneCase)BeanMapper.map((Object)webSceneCaseEntity, WebSceneCase.class);
        this.joinTemplate.joinQuery((Object)webSceneCase);
        return webSceneCase;
    }

    public List<WebSceneCase> findList(List<String> idList) {
        List<WebSceneCaseEntity> testCaseEntityList = this.webSceneCaseDao.findWebSceneCaseList(idList);
        List webSceneCaseList = BeanMapper.mapList(testCaseEntityList, WebSceneCase.class);
        return webSceneCaseList;
    }

    public WebSceneCase findWebSceneCase(@NotNull String id) {
        WebSceneCase webSceneCase = this.findOne(id);
        this.joinTemplate.joinQuery((Object)webSceneCase);
        TestCase testCase = webSceneCase.getTestCase();
        if (testCase.getCategory() != null) {
            Category category = this.categoryService.findCategory(testCase.getCategory().getId());
            webSceneCase.getTestCase().setCategory(category);
        }
        if (testCase.getUpdateUser() != null) {
            User updateUser = this.userService.findUser(testCase.getUpdateUser().getId());
            webSceneCase.getTestCase().setUpdateUser(updateUser);
        }
        return webSceneCase;
    }

    public List<WebSceneCase> findAllWebSceneCase() {
        List<WebSceneCaseEntity> testCaseEntityList = this.webSceneCaseDao.findAllWebSceneCase();
        List webSceneCaseList = BeanMapper.mapList(testCaseEntityList, WebSceneCase.class);
        this.joinTemplate.joinQuery(webSceneCaseList);
        return webSceneCaseList;
    }

    public List<WebSceneCase> findWebSceneCaseList(WebSceneCaseQuery webSceneCaseQuery) {
        List<WebSceneCaseEntity> testCaseEntityList = this.webSceneCaseDao.findWebSceneCaseList(webSceneCaseQuery);
        List webSceneCaseList = BeanMapper.mapList(testCaseEntityList, WebSceneCase.class);
        this.joinTemplate.joinQuery(webSceneCaseList);
        return webSceneCaseList;
    }

    public Pagination<WebSceneCase> findWebSceneCasePage(WebSceneCaseQuery webSceneCaseQuery) {
        Pagination<WebSceneCaseEntity> pagination = this.webSceneCaseDao.findWebSceneCasePage(webSceneCaseQuery);
        List webSceneCaseList = BeanMapper.mapList((List)pagination.getDataList(), WebSceneCase.class);
        this.joinTemplate.joinQuery(webSceneCaseList);
        return PaginationBuilder.build(pagination, (List)webSceneCaseList);
    }

    public List<WebSceneCase> findWebSceneCaseListByTestCase(TestCaseQuery testCaseQuery) {
        List testCaseList = this.testCaseService.findTestCaseList(testCaseQuery);
        ArrayList<WebSceneCase> webSceneCaseList = new ArrayList<WebSceneCase>();
        if (CollectionUtils.isNotEmpty((Collection)testCaseList)) {
            for (TestCase testCase : testCaseList) {
                WebSceneCase webSceneCase = this.findWebSceneCase(testCase.getId());
                if (ObjectUtils.isEmpty((Object)webSceneCase)) continue;
                webSceneCaseList.add(webSceneCase);
            }
        }
        return webSceneCaseList;
    }
}

