/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.web.perf.instance.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.web.perf.instance.dao.WebPerfInstanceDao;
import io.tiklab.teston.test.web.perf.instance.entity.WebPerfInstanceEntity;
import io.tiklab.teston.test.web.perf.instance.model.WebPerfInstance;
import io.tiklab.teston.test.web.perf.instance.model.WebPerfInstanceQuery;
import io.tiklab.teston.test.web.perf.instance.service.WebPerfInstanceService;
import java.sql.Timestamp;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebPerfInstanceServiceImpl
implements WebPerfInstanceService {
    @Autowired
    WebPerfInstanceDao appPerfInstanceDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createWebPerfInstance(@NotNull @Valid WebPerfInstance webPerfInstance) {
        WebPerfInstanceEntity webPerfInstanceEntity = (WebPerfInstanceEntity)BeanMapper.map((Object)webPerfInstance, WebPerfInstanceEntity.class);
        webPerfInstanceEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return this.appPerfInstanceDao.createWebPerfInstance(webPerfInstanceEntity);
    }

    public void updateWebPerfInstance(@NotNull @Valid WebPerfInstance webPerfInstance) {
        WebPerfInstanceEntity webPerfInstanceEntity = (WebPerfInstanceEntity)BeanMapper.map((Object)webPerfInstance, WebPerfInstanceEntity.class);
        this.appPerfInstanceDao.updateWebPerfInstance(webPerfInstanceEntity);
    }

    public void deleteWebPerfInstance(@NotNull String id) {
        this.appPerfInstanceDao.deleteWebPerfInstance(id);
    }

    public WebPerfInstance findOne(String id) {
        WebPerfInstanceEntity webPerfInstanceEntity = this.appPerfInstanceDao.findWebPerfInstance(id);
        WebPerfInstance webPerfInstance = (WebPerfInstance)BeanMapper.map((Object)webPerfInstanceEntity, WebPerfInstance.class);
        return webPerfInstance;
    }

    public List<WebPerfInstance> findList(List<String> idList) {
        List<WebPerfInstanceEntity> webPerfInstanceEntities = this.appPerfInstanceDao.findWebPerfInstanceList(idList);
        List webPerfInstanceList = BeanMapper.mapList(webPerfInstanceEntities, WebPerfInstance.class);
        return webPerfInstanceList;
    }

    public WebPerfInstance findWebPerfInstance(@NotNull String id) {
        WebPerfInstance webPerfInstance = this.findOne(id);
        this.joinTemplate.joinQuery((Object)webPerfInstance);
        return webPerfInstance;
    }

    public List<WebPerfInstance> findAllWebPerfInstance() {
        List<WebPerfInstanceEntity> webPerfInstanceEntities = this.appPerfInstanceDao.findAllWebPerfInstance();
        List webPerfInstanceList = BeanMapper.mapList(webPerfInstanceEntities, WebPerfInstance.class);
        this.joinTemplate.joinQuery(webPerfInstanceList);
        return webPerfInstanceList;
    }

    public List<WebPerfInstance> findWebPerfInstanceList(WebPerfInstanceQuery performanceInstanceQuery) {
        List<WebPerfInstanceEntity> webPerfInstanceEntities = this.appPerfInstanceDao.findWebPerfInstanceList(performanceInstanceQuery);
        List webPerfInstanceList = BeanMapper.mapList(webPerfInstanceEntities, WebPerfInstance.class);
        this.joinTemplate.joinQuery(webPerfInstanceList);
        return webPerfInstanceList;
    }

    public Pagination<WebPerfInstance> findWebPerfInstancePage(WebPerfInstanceQuery performanceInstanceQuery) {
        Pagination<WebPerfInstanceEntity> pagination = this.appPerfInstanceDao.findWebPerfInstancePage(performanceInstanceQuery);
        List webPerfInstanceList = BeanMapper.mapList((List)pagination.getDataList(), WebPerfInstance.class);
        this.joinTemplate.joinQuery(webPerfInstanceList);
        return PaginationBuilder.build(pagination, (List)webPerfInstanceList);
    }
}

