/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.web.perf.execute.service;

import io.tiklab.rpc.client.router.lookup.FixedLookup;
import io.tiklab.rpc.client.router.lookup.Lookup;
import io.tiklab.teston.agent.web.perf.WebPerfTestService;
import io.tiklab.teston.support.agentconfig.model.AgentConfig;
import io.tiklab.teston.support.agentconfig.model.AgentConfigQuery;
import io.tiklab.teston.support.agentconfig.service.AgentConfigService;
import io.tiklab.teston.test.web.perf.cases.model.WebPerfCase;
import io.tiklab.teston.test.web.perf.cases.model.WebPerfStep;
import io.tiklab.teston.test.web.perf.cases.model.WebPerfStepQuery;
import io.tiklab.teston.test.web.perf.cases.service.WebPerfCaseService;
import io.tiklab.teston.test.web.perf.cases.service.WebPerfStepService;
import io.tiklab.teston.test.web.perf.execute.model.WebPerfTestRequest;
import io.tiklab.teston.test.web.perf.execute.model.WebPerfTestResponse;
import io.tiklab.teston.test.web.perf.execute.service.WebPerfTestDispatchService;
import io.tiklab.teston.test.web.perf.instance.model.WebPerfInstance;
import io.tiklab.teston.test.web.perf.instance.model.WebPerfInstanceQuery;
import io.tiklab.teston.test.web.perf.instance.service.WebPerfInstanceService;
import io.tiklab.teston.test.web.scene.cases.model.WebSceneStepQuery;
import io.tiklab.teston.test.web.scene.cases.service.WebSceneStepService;
import io.tiklab.teston.test.web.scene.execute.model.WebSceneTestRequest;
import io.tiklab.teston.test.web.scene.instance.model.WebSceneInstance;
import io.tiklab.teston.test.web.utils.RpcClientWebUtil;
import io.tiklab.teston.test.web.utils.TestWebUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class WebPerfTestDispatchServiceImpl
implements WebPerfTestDispatchService {
    public static final Logger logger = LoggerFactory.getLogger(WebPerfTestDispatchServiceImpl.class);
    @Autowired
    WebSceneStepService webSceneStepService;
    @Autowired
    WebPerfCaseService webPerfCaseService;
    @Autowired
    WebPerfStepService webPerfStepService;
    @Autowired
    WebPerfInstanceService webPerfInstanceService;
    @Autowired
    AgentConfigService agentConfigService;
    @Autowired
    RpcClientWebUtil rpcClientWebUtil;
    @Autowired
    TestWebUtil testWebUtil;
    @Autowired
    WebPerfTestService webPerfTestService;
    @Value(value="${teston-agent.embbed.enable:false}")
    Boolean enable;
    private List<AgentConfig> agentConfigList;
    private Integer executeCount;
    public Integer status = 0;
    private String webPerfInstanceId;

    WebPerfTestService webPerfTestServiceRPC(String agentUrl) {
        return (WebPerfTestService)this.rpcClientWebUtil.rpcClient().getBean(WebPerfTestService.class, (Lookup)new FixedLookup(agentUrl));
    }

    public void execute(WebPerfTestRequest webPerfTestRequest) {
        this.status = 1;
        this.webPerfInstanceId = null;
        String webPerfId = webPerfTestRequest.getWebPerfCase().getId();
        WebPerfCase webPerfCase = this.webPerfCaseService.findWebPerfCase(webPerfId);
        webPerfTestRequest.setWebPerfCase(webPerfCase);
        WebPerfStepQuery webPerfStepQuery = new WebPerfStepQuery();
        webPerfStepQuery.setWebPerfId(webPerfId);
        List webPerfStepList = this.webPerfStepService.findWebPerfStepList(webPerfStepQuery);
        List<WebSceneTestRequest> webSceneTestRequestList = this.processExeData(webPerfStepList);
        webPerfTestRequest.setWebSceneTestRequestList(webSceneTestRequestList);
        this.executeCount = webPerfCase.getExecuteCount();
        this.agentConfigList = this.agentConfigService.findAgentConfigList(new AgentConfigQuery());
        int agentSize = this.agentConfigList.size();
        Integer executeType = webPerfCase.getExecuteType();
        List<Object> distributionList = new ArrayList();
        if (executeType == 1) {
            logger.info("--------------------------------------loop-----------------------------------");
            distributionList = this.testWebUtil.loop(this.executeCount, agentSize);
        }
        if (executeType == 2) {
            distributionList = this.testWebUtil.random(this.executeCount, agentSize);
        }
        for (int i = 0; i < agentSize; ++i) {
            webPerfTestRequest.setExeNum((Integer)distributionList.get(i));
            AgentConfig agentConfig = this.agentConfigList.get(i);
            if (this.enable.booleanValue()) {
                this.webPerfTestService.execute(webPerfTestRequest);
                continue;
            }
            this.webPerfTestServiceRPC(agentConfig.getUrl()).execute(webPerfTestRequest);
        }
    }

    public WebPerfTestResponse exeResult(WebPerfTestRequest webPerfTestRequest) {
        WebPerfTestResponse webPerfTestResponse = new WebPerfTestResponse();
        ArrayList arrayList = new ArrayList();
        WebPerfTestResponse response = null;
        for (int i = 0; i < this.agentConfigList.size(); ++i) {
            response = this.enable != false ? this.webPerfTestService.exeResult(webPerfTestRequest) : this.webPerfTestServiceRPC(this.agentConfigList.get(i).getUrl()).exeResult(webPerfTestRequest);
            if (!CollectionUtils.isNotEmpty((Collection)response.getWebSceneInstanceList())) continue;
            arrayList.addAll(response.getWebSceneInstanceList());
        }
        webPerfTestResponse.setWebSceneInstanceList(arrayList);
        this.status = webPerfTestResponse.getWebSceneInstanceList().size() == this.executeCount.intValue() ? Integer.valueOf(0) : Integer.valueOf(1);
        webPerfTestResponse.setStatus(this.status);
        WebPerfInstance webPerfInstance = this.processPerfTestData(webPerfTestResponse);
        webPerfTestResponse.setWebPerfInstance(webPerfInstance);
        if (webPerfTestRequest.getExeType() == null) {
            String webPerfId = webPerfTestRequest.getWebPerfCase().getId();
            webPerfInstance.setWebPerfId(webPerfId);
            if (this.webPerfInstanceId == null) {
                WebPerfInstanceQuery webPerfInstanceQuery = new WebPerfInstanceQuery();
                webPerfInstanceQuery.setWebPerfId(webPerfId);
                List webPerfInstanceList = this.webPerfInstanceService.findWebPerfInstanceList(webPerfInstanceQuery);
                if (webPerfInstanceList != null && webPerfInstanceList.size() > 0) {
                    Integer executeNumber = ((WebPerfInstance)webPerfInstanceList.get(0)).getExecuteNumber();
                    executeNumber = executeNumber + 1;
                    webPerfInstance.setExecuteNumber(executeNumber);
                } else {
                    webPerfInstance.setExecuteNumber(Integer.valueOf(1));
                }
                this.webPerfInstanceId = this.webPerfInstanceService.createWebPerfInstance(webPerfInstance);
            } else {
                webPerfInstance.setId(this.webPerfInstanceId);
                this.webPerfInstanceService.updateWebPerfInstance(webPerfInstance);
            }
        }
        return webPerfTestResponse;
    }

    private List<WebSceneTestRequest> processExeData(List<WebPerfStep> webPerfStepList) {
        ArrayList<WebSceneTestRequest> webSceneTestRequestList = new ArrayList<WebSceneTestRequest>();
        if (CollectionUtils.isNotEmpty(webPerfStepList)) {
            for (WebPerfStep webPerfStep : webPerfStepList) {
                WebSceneTestRequest webSceneTestRequest = new WebSceneTestRequest();
                WebSceneStepQuery webSceneStepQuery = new WebSceneStepQuery();
                webSceneStepQuery.setWebSceneId(webPerfStep.getWebScene().getId());
                List webSceneStepList = this.webSceneStepService.findWebSceneStepList(webSceneStepQuery);
                webSceneTestRequest.setWebSceneStepList(webSceneStepList);
                webSceneTestRequestList.add(webSceneTestRequest);
            }
        }
        return webSceneTestRequestList;
    }

    private WebPerfInstance processPerfTestData(WebPerfTestResponse webPerfTestResponse) {
        WebPerfInstance webPerfInstance = new WebPerfInstance();
        int size = webPerfTestResponse.getWebSceneInstanceList().size();
        webPerfInstance.setTotal(Integer.valueOf(size));
        int passNum = 0;
        for (WebSceneInstance webSceneInstance : webPerfTestResponse.getWebSceneInstanceList()) {
            if (!webSceneInstance.getResult().equals(1)) continue;
            ++passNum;
        }
        String passRate = this.testWebUtil.processRate(passNum, size);
        webPerfInstance.setPassRate(passRate);
        webPerfInstance.setPassNum(Integer.valueOf(passNum));
        webPerfInstance.setFailNum(Integer.valueOf(size - passNum));
        String errorRate = this.testWebUtil.processRate(size - passNum, size);
        webPerfInstance.setErrorRate(errorRate);
        if (size == passNum) {
            webPerfInstance.setResult(Integer.valueOf(1));
        } else {
            webPerfInstance.setResult(Integer.valueOf(0));
        }
        return webPerfInstance;
    }
}

