/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.web.perf.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.test.model.TestCase;
import io.tiklab.teston.test.test.service.TestCaseService;
import io.tiklab.teston.test.web.perf.cases.dao.WebPerfStepDao;
import io.tiklab.teston.test.web.perf.cases.entity.WebPerfStepEntity;
import io.tiklab.teston.test.web.perf.cases.model.WebPerfStep;
import io.tiklab.teston.test.web.perf.cases.model.WebPerfStepQuery;
import io.tiklab.teston.test.web.perf.cases.service.WebPerfStepService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebPerfStepServiceImpl
implements WebPerfStepService {
    @Autowired
    WebPerfStepDao webPerfStepDao;
    @Autowired
    TestCaseService testCaseService;
    @Autowired
    JoinTemplate joinTemplate;

    public String createWebPerfStep(@NotNull @Valid WebPerfStep webPerfStep) {
        WebPerfStepEntity webPerfStepEntity = (WebPerfStepEntity)BeanMapper.map((Object)webPerfStep, WebPerfStepEntity.class);
        webPerfStepEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return this.webPerfStepDao.createWebPerfStep(webPerfStepEntity);
    }

    public void updateWebPerfStep(@NotNull @Valid WebPerfStep webPerfStep) {
        WebPerfStepEntity webPerfStepEntity = (WebPerfStepEntity)BeanMapper.map((Object)webPerfStep, WebPerfStepEntity.class);
        this.webPerfStepDao.updateWebPerfStep(webPerfStepEntity);
    }

    public void deleteWebPerfStep(@NotNull String id) {
        this.webPerfStepDao.deleteWebPerfStep(id);
    }

    public WebPerfStep findOne(String id) {
        WebPerfStepEntity webPerfStepEntity = this.webPerfStepDao.findWebPerfStep(id);
        WebPerfStep webPerfStep = (WebPerfStep)BeanMapper.map((Object)webPerfStepEntity, WebPerfStep.class);
        return webPerfStep;
    }

    public List<WebPerfStep> findList(List<String> idList) {
        List<WebPerfStepEntity> webPerfStepEntityList = this.webPerfStepDao.findWebPerfStepList(idList);
        List webPerfStepList = BeanMapper.mapList(webPerfStepEntityList, WebPerfStep.class);
        return webPerfStepList;
    }

    public WebPerfStep findWebPerfStep(@NotNull String id) {
        WebPerfStep webPerfStep = this.findOne(id);
        this.joinTemplate.joinQuery((Object)webPerfStep);
        return webPerfStep;
    }

    public List<WebPerfStep> findAllWebPerfStep() {
        List<WebPerfStepEntity> webPerfStepEntityList = this.webPerfStepDao.findAllWebPerfStep();
        List webPerfStepList = BeanMapper.mapList(webPerfStepEntityList, WebPerfStep.class);
        this.joinTemplate.joinQuery(webPerfStepList);
        return webPerfStepList;
    }

    public List<WebPerfStep> findWebPerfStepList(WebPerfStepQuery webPerfStepQuery) {
        List<WebPerfStepEntity> webPerfStepEntityList = this.webPerfStepDao.findWebPerfStepList(webPerfStepQuery);
        List webPerfStepList = BeanMapper.mapList(webPerfStepEntityList, WebPerfStep.class);
        this.joinTemplate.joinQuery(webPerfStepList);
        ArrayList<WebPerfStep> arrayList = new ArrayList<WebPerfStep>();
        if (webPerfStepList.size() > 0) {
            for (WebPerfStep webPerfStep : webPerfStepList) {
                TestCase testCase = this.testCaseService.findTestCase(webPerfStep.getWebScene().getId());
                webPerfStep.getWebScene().setTestCase(testCase);
                arrayList.add(webPerfStep);
            }
        }
        return webPerfStepList;
    }

    public Pagination<WebPerfStep> findWebPerfStepPage(WebPerfStepQuery webPerfStepQuery) {
        Pagination<WebPerfStepEntity> pagination = this.webPerfStepDao.findWebPerfStepPage(webPerfStepQuery);
        List webPerfStepList = BeanMapper.mapList((List)pagination.getDataList(), WebPerfStep.class);
        this.joinTemplate.joinQuery(webPerfStepList);
        return PaginationBuilder.build(pagination, (List)webPerfStepList);
    }

    public void bindWebScene(List<WebPerfStep> webPerfStepList) {
        if (CollectionUtils.isNotEmpty(webPerfStepList)) {
            for (WebPerfStep webPerfStep : webPerfStepList) {
                this.createWebPerfStep(webPerfStep);
            }
        }
    }
}

