/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.web.perf.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.category.model.Category;
import io.tiklab.teston.category.service.CategoryService;
import io.tiklab.teston.test.test.model.TestCase;
import io.tiklab.teston.test.test.model.TestCaseQuery;
import io.tiklab.teston.test.test.service.TestCaseService;
import io.tiklab.teston.test.web.perf.cases.dao.WebPerfCaseDao;
import io.tiklab.teston.test.web.perf.cases.entity.WebPerfCaseEntity;
import io.tiklab.teston.test.web.perf.cases.model.WebPerfCase;
import io.tiklab.teston.test.web.perf.cases.model.WebPerfCaseQuery;
import io.tiklab.teston.test.web.perf.cases.service.WebPerfCaseService;
import io.tiklab.user.user.model.User;
import io.tiklab.user.user.service.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class WebPerfCaseServiceImpl
implements WebPerfCaseService {
    @Autowired
    WebPerfCaseDao webPerfCaseDao;
    @Autowired
    TestCaseService testCaseService;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    CategoryService categoryService;
    @Autowired
    UserService userService;

    public String createWebPerfCase(@NotNull @Valid WebPerfCase webPerfCase) {
        WebPerfCaseEntity webPerfCaseEntity = (WebPerfCaseEntity)BeanMapper.map((Object)webPerfCase, WebPerfCaseEntity.class);
        webPerfCaseEntity.setExecuteCount(1);
        webPerfCaseEntity.setThreadCount(1);
        webPerfCaseEntity.setExecuteType(1);
        String id = this.webPerfCaseDao.createWebPerfCase(webPerfCaseEntity);
        webPerfCaseEntity.setTestCaseId(id);
        webPerfCaseEntity.setId(id);
        this.webPerfCaseDao.updateWebPerfCase(webPerfCaseEntity);
        TestCase testCase = webPerfCase.getTestCase();
        testCase.setId(id);
        this.testCaseService.createTestCase(testCase);
        return id;
    }

    public void updateWebPerfCase(@NotNull @Valid WebPerfCase webPerfCase) {
        WebPerfCaseEntity webPerfCaseEntity = (WebPerfCaseEntity)BeanMapper.map((Object)webPerfCase, WebPerfCaseEntity.class);
        webPerfCaseEntity.setTestCaseId(webPerfCase.getId());
        this.webPerfCaseDao.updateWebPerfCase(webPerfCaseEntity);
        this.testCaseService.updateTestCase(webPerfCase.getTestCase());
    }

    public void deleteWebPerfCase(@NotNull String id) {
        this.webPerfCaseDao.deleteWebPerfCase(id);
        this.testCaseService.deleteTestCase(id);
    }

    public WebPerfCase findOne(String id) {
        WebPerfCaseEntity webPerfCaseEntity = this.webPerfCaseDao.findWebPerfCase(id);
        WebPerfCase webPerfCase = (WebPerfCase)BeanMapper.map((Object)webPerfCaseEntity, WebPerfCase.class);
        return webPerfCase;
    }

    public List<WebPerfCase> findList(List<String> idList) {
        List<WebPerfCaseEntity> webPerfCaseEntityList = this.webPerfCaseDao.findWebPerfCaseList(idList);
        List webPerfCaseList = BeanMapper.mapList(webPerfCaseEntityList, WebPerfCase.class);
        return webPerfCaseList;
    }

    public WebPerfCase findWebPerfCase(@NotNull String id) {
        WebPerfCase webPerfCase = this.findOne(id);
        this.joinTemplate.joinQuery((Object)webPerfCase);
        TestCase testCase = webPerfCase.getTestCase();
        if (testCase.getCategory() != null) {
            Category category = this.categoryService.findCategory(testCase.getCategory().getId());
            webPerfCase.getTestCase().setCategory(category);
        }
        if (testCase.getUpdateUser() != null) {
            User updateUser = this.userService.findUser(testCase.getUpdateUser().getId());
            webPerfCase.getTestCase().setUpdateUser(updateUser);
        }
        return webPerfCase;
    }

    public List<WebPerfCase> findAllWebPerfCase() {
        List<WebPerfCaseEntity> webPerfCaseEntityList = this.webPerfCaseDao.findAllWebPerfCase();
        List webPerfCaseList = BeanMapper.mapList(webPerfCaseEntityList, WebPerfCase.class);
        this.joinTemplate.joinQuery(webPerfCaseList);
        return webPerfCaseList;
    }

    public List<WebPerfCase> findWebPerfCaseList(WebPerfCaseQuery webPerfCaseQuery) {
        List<WebPerfCaseEntity> webPerfCaseEntityList = this.webPerfCaseDao.findWebPerfCaseList(webPerfCaseQuery);
        List webPerfCaseList = BeanMapper.mapList(webPerfCaseEntityList, WebPerfCase.class);
        this.joinTemplate.joinQuery(webPerfCaseList);
        return webPerfCaseList;
    }

    public Pagination<WebPerfCase> findWebPerfCasePage(WebPerfCaseQuery webPerfCaseQuery) {
        Pagination<WebPerfCaseEntity> pagination = this.webPerfCaseDao.findWebPerfCasePage(webPerfCaseQuery);
        List webPerfCaseList = BeanMapper.mapList((List)pagination.getDataList(), WebPerfCase.class);
        this.joinTemplate.joinQuery(webPerfCaseList);
        return PaginationBuilder.build(pagination, (List)webPerfCaseList);
    }

    public List<WebPerfCase> findWebPerfCaseListByTestCase(TestCaseQuery testCaseQuery) {
        List testCaseList = this.testCaseService.findTestCaseList(testCaseQuery);
        ArrayList<WebPerfCase> webPerfCaseList = new ArrayList<WebPerfCase>();
        if (CollectionUtils.isNotEmpty((Collection)testCaseList)) {
            for (TestCase testCase : testCaseList) {
                WebPerfCase webPerfCase = this.findWebPerfCase(testCase.getId());
                webPerfCaseList.add(webPerfCase);
            }
        }
        return webPerfCaseList;
    }
}

