/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.test.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.dal.jpa.criterial.condition.DeleteCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.DeleteBuilders;
import io.tiklab.eam.common.context.LoginContext;
import io.tiklab.join.JoinTemplate;
import io.tiklab.rpc.annotation.Exporter;
import io.tiklab.teston.test.apix.http.perf.instance.model.ApiPerfInstance;
import io.tiklab.teston.test.apix.http.perf.instance.model.ApiPerfInstanceQuery;
import io.tiklab.teston.test.apix.http.perf.instance.service.ApiPerfInstanceService;
import io.tiklab.teston.test.apix.http.scene.instance.model.ApiSceneInstance;
import io.tiklab.teston.test.apix.http.scene.instance.model.ApiSceneInstanceQuery;
import io.tiklab.teston.test.apix.http.scene.instance.service.ApiSceneInstanceService;
import io.tiklab.teston.test.apix.http.unit.instance.model.ApiUnitInstanceBind;
import io.tiklab.teston.test.apix.http.unit.instance.model.ApiUnitInstanceBindQuery;
import io.tiklab.teston.test.apix.http.unit.instance.service.ApiUnitInstanceBindService;
import io.tiklab.teston.test.app.perf.instance.mode.AppPerfInstance;
import io.tiklab.teston.test.app.perf.instance.mode.AppPerfInstanceQuery;
import io.tiklab.teston.test.app.perf.instance.service.AppPerfInstanceService;
import io.tiklab.teston.test.app.scene.instance.model.AppSceneInstance;
import io.tiklab.teston.test.app.scene.instance.model.AppSceneInstanceQuery;
import io.tiklab.teston.test.app.scene.instance.service.AppSceneInstanceService;
import io.tiklab.teston.test.test.dao.TestCaseDao;
import io.tiklab.teston.test.test.entity.TestCasesEntity;
import io.tiklab.teston.test.test.model.TestCase;
import io.tiklab.teston.test.test.model.TestCaseQuery;
import io.tiklab.teston.test.test.model.TestCaseRecent;
import io.tiklab.teston.test.test.model.TestCaseRecentQuery;
import io.tiklab.teston.test.test.service.TestCaseRecentService;
import io.tiklab.teston.test.test.service.TestCaseService;
import io.tiklab.teston.test.web.perf.instance.model.WebPerfInstance;
import io.tiklab.teston.test.web.perf.instance.model.WebPerfInstanceQuery;
import io.tiklab.teston.test.web.perf.instance.service.WebPerfInstanceService;
import io.tiklab.teston.test.web.scene.instance.model.WebSceneInstance;
import io.tiklab.teston.test.web.scene.instance.model.WebSceneInstanceQuery;
import io.tiklab.teston.test.web.scene.instance.service.WebSceneInstanceService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
@Exporter
public class TestCaseServiceImpl
implements TestCaseService {
    @Autowired
    TestCaseDao testCaseDao;
    @Autowired
    TestCaseRecentService testCaseRecentService;
    @Autowired
    ApiUnitInstanceBindService apiUnitInstanceBindService;
    @Autowired
    ApiSceneInstanceService apiSceneInstanceService;
    @Autowired
    ApiPerfInstanceService apiPerfInstanceService;
    @Autowired
    WebSceneInstanceService webSceneInstanceService;
    @Autowired
    WebPerfInstanceService webPerfInstanceService;
    @Autowired
    AppSceneInstanceService appSceneInstanceService;
    @Autowired
    AppPerfInstanceService appPerfInstanceService;
    @Autowired
    JoinTemplate joinTemplate;

    public String createTestCase(TestCase testCase) {
        TestCasesEntity testCasesEntity = (TestCasesEntity)BeanMapper.map((Object)testCase, TestCasesEntity.class);
        String userId = LoginContext.getLoginId();
        testCasesEntity.setCreateUser(userId);
        testCasesEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        testCasesEntity.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        String id = this.testCaseDao.createTestCase(testCasesEntity);
        return id;
    }

    public void updateTestCase(TestCase testCase) {
        TestCasesEntity testCasesEntity = (TestCasesEntity)BeanMapper.map((Object)testCase, TestCasesEntity.class);
        testCasesEntity.setUpdateTime(new Timestamp(System.currentTimeMillis()));
        String userId = LoginContext.getLoginId();
        testCasesEntity.setUpdateUser(userId);
        this.testCaseDao.updateTestCase(testCasesEntity);
    }

    public void deleteTestCase(@NotNull String id) {
        TestCaseRecentQuery testCaseRecent = new TestCaseRecentQuery();
        testCaseRecent.setTestCaseId(id);
        List testCaseRecentList = this.testCaseRecentService.findTestCaseRecentList(testCaseRecent);
        if (testCaseRecentList != null && testCaseRecentList.size() > 0) {
            this.testCaseRecentService.deleteTestCaseRecent(((TestCaseRecent)testCaseRecentList.get(0)).getId());
        }
        this.testCaseDao.deleteTestCase(id);
    }

    public void deleteTestCaseByCategoryId(String categoryId) {
        DeleteCondition deleteCondition = DeleteBuilders.createDelete(TestCasesEntity.class).eq("categoryId", (Object)categoryId).get();
        this.testCaseDao.deleteTestCase(deleteCondition);
    }

    public TestCase findOne(String id) {
        TestCasesEntity testCasesEntity = this.testCaseDao.findTestCase(id);
        TestCase testCase = (TestCase)BeanMapper.map((Object)testCasesEntity, TestCase.class);
        return testCase;
    }

    public List<TestCase> findList(List<String> idList) {
        List<TestCasesEntity> testCaseList = this.testCaseDao.findTestCaseList(idList);
        List mapList = BeanMapper.mapList(testCaseList, TestCase.class);
        return mapList;
    }

    public TestCase findTestCase(@NotNull String id) {
        TestCase testCase = this.findOne(id);
        this.joinTemplate.joinQuery((Object)testCase);
        return testCase;
    }

    public List<TestCase> findAllTestCase() {
        List<TestCasesEntity> testCasesEntityList = this.testCaseDao.findAllTestCase();
        List testCaseList = BeanMapper.mapList(testCasesEntityList, TestCase.class);
        this.joinTemplate.joinQuery(testCaseList);
        return testCaseList;
    }

    public List<TestCase> findTestCaseList(TestCaseQuery testCaseQuery) {
        List<TestCasesEntity> testCasesEntityList = this.testCaseDao.findTestCaseList(testCaseQuery);
        List testCaseList = BeanMapper.mapList(testCasesEntityList, TestCase.class);
        this.joinTemplate.joinQuery(testCaseList);
        return testCaseList;
    }

    public Pagination<TestCase> findTestCasePage(TestCaseQuery testCaseQuery) {
        Pagination<TestCasesEntity> pagination = this.testCaseDao.findTestCasePage(testCaseQuery);
        List testCaseList = BeanMapper.mapList((List)pagination.getDataList(), TestCase.class);
        this.joinTemplate.joinQuery(testCaseList);
        List<TestCase> newTestCaseList = this.recentInstance(testCaseList);
        return PaginationBuilder.build(pagination, newTestCaseList);
    }

    private List<TestCase> recentInstance(List<TestCase> testCaseList) {
        ArrayList<TestCase> newTestCaseList = new ArrayList<TestCase>();
        if (testCaseList != null && testCaseList.size() > 0) {
            for (TestCase testCase : testCaseList) {
                HashMap<String, Object> recentInstance = new HashMap<String, Object>();
                if (Objects.equals(testCase.getTestType(), "auto") || Objects.equals(testCase.getTestType(), "perform")) {
                    switch (testCase.getCaseType()) {
                        case "api-unit": {
                            ApiUnitInstanceBindQuery apiUnitInstanceBindQuery = new ApiUnitInstanceBindQuery();
                            apiUnitInstanceBindQuery.setApiUnitId(testCase.getId());
                            List apiUnitInstanceBindList = this.apiUnitInstanceBindService.findApiUnitInstanceBindList(apiUnitInstanceBindQuery);
                            if (apiUnitInstanceBindList != null && apiUnitInstanceBindList.size() > 0) {
                                ApiUnitInstanceBind apiUnitInstanceBind = (ApiUnitInstanceBind)apiUnitInstanceBindList.get(0);
                                recentInstance.put("result", apiUnitInstanceBind.getApiUnitInstance().getResult());
                                recentInstance.put("executeNumber", apiUnitInstanceBind.getApiUnitInstance().getExecuteNumber());
                                recentInstance.put("instanceId", apiUnitInstanceBind.getId());
                                break;
                            }
                            recentInstance.put("result", 2);
                            recentInstance.put("instanceId", null);
                            recentInstance.put("executeNumber", null);
                            break;
                        }
                        case "api-scene": {
                            ApiSceneInstanceQuery apiSceneInstanceQuery = new ApiSceneInstanceQuery();
                            apiSceneInstanceQuery.setApiSceneId(testCase.getId());
                            List apiSceneInstanceList = this.apiSceneInstanceService.findApiSceneInstanceList(apiSceneInstanceQuery);
                            if (apiSceneInstanceList != null && apiSceneInstanceList.size() > 0) {
                                ApiSceneInstance apiSceneInstance = (ApiSceneInstance)apiSceneInstanceList.get(0);
                                recentInstance.put("result", apiSceneInstance.getResult());
                                recentInstance.put("executeNumber", apiSceneInstance.getExecuteNumber());
                                recentInstance.put("instanceId", apiSceneInstance.getId());
                                break;
                            }
                            recentInstance.put("result", 2);
                            recentInstance.put("instanceId", null);
                            recentInstance.put("executeNumber", null);
                            break;
                        }
                        case "api-perform": {
                            ApiPerfInstanceQuery apiPerfInstanceQuery = new ApiPerfInstanceQuery();
                            apiPerfInstanceQuery.setApiPerfId(testCase.getId());
                            List apiPerfInstanceList = this.apiPerfInstanceService.findApiPerfInstanceList(apiPerfInstanceQuery);
                            if (apiPerfInstanceList != null && apiPerfInstanceList.size() > 0) {
                                ApiPerfInstance apiPerfInstance = (ApiPerfInstance)apiPerfInstanceList.get(0);
                                recentInstance.put("result", apiPerfInstance.getResult());
                                recentInstance.put("instanceId", apiPerfInstance.getId());
                                recentInstance.put("executeNumber", apiPerfInstance.getExecuteNumber());
                                break;
                            }
                            recentInstance.put("result", 2);
                            recentInstance.put("instanceId", null);
                            recentInstance.put("executeNumber", null);
                            break;
                        }
                        case "web-scene": {
                            WebSceneInstanceQuery webSceneInstanceQuery = new WebSceneInstanceQuery();
                            webSceneInstanceQuery.setWebSceneId(testCase.getId());
                            List webSceneInstanceList = this.webSceneInstanceService.findWebSceneInstanceList(webSceneInstanceQuery);
                            if (webSceneInstanceList != null && webSceneInstanceList.size() > 0) {
                                WebSceneInstance webSceneInstance = (WebSceneInstance)webSceneInstanceList.get(0);
                                recentInstance.put("result", webSceneInstance.getResult());
                                recentInstance.put("instanceId", webSceneInstance.getId());
                                recentInstance.put("executeNumber", webSceneInstance.getExecuteNumber());
                                break;
                            }
                            recentInstance.put("result", 2);
                            recentInstance.put("instanceId", null);
                            recentInstance.put("executeNumber", null);
                            break;
                        }
                        case "web-perform": {
                            WebPerfInstanceQuery webPerfInstanceQuery = new WebPerfInstanceQuery();
                            webPerfInstanceQuery.setWebPerfId(testCase.getId());
                            List webPerfInstanceList = this.webPerfInstanceService.findWebPerfInstanceList(webPerfInstanceQuery);
                            if (webPerfInstanceList != null && webPerfInstanceList.size() > 0) {
                                WebPerfInstance webPerfInstance = (WebPerfInstance)webPerfInstanceList.get(0);
                                recentInstance.put("result", webPerfInstance.getResult());
                                recentInstance.put("instanceId", webPerfInstance.getId());
                                recentInstance.put("executeNumber", webPerfInstance.getExecuteNumber());
                                break;
                            }
                            recentInstance.put("result", 2);
                            recentInstance.put("instanceId", null);
                            recentInstance.put("executeNumber", null);
                            break;
                        }
                        case "app-scene": {
                            AppSceneInstanceQuery appSceneInstanceQuery = new AppSceneInstanceQuery();
                            appSceneInstanceQuery.setAppSceneId(testCase.getId());
                            List appSceneInstanceList = this.appSceneInstanceService.findAppSceneInstanceList(appSceneInstanceQuery);
                            if (appSceneInstanceList != null && appSceneInstanceList.size() > 0) {
                                AppSceneInstance appSceneInstance = (AppSceneInstance)appSceneInstanceList.get(0);
                                recentInstance.put("result", appSceneInstance.getResult());
                                recentInstance.put("instanceId", appSceneInstance.getId());
                                recentInstance.put("executeNumber", appSceneInstance.getExecuteNumber());
                                break;
                            }
                            recentInstance.put("result", 2);
                            recentInstance.put("instanceId", null);
                            recentInstance.put("executeNumber", null);
                            break;
                        }
                        case "app-perform": {
                            AppPerfInstanceQuery appPerfInstanceQuery = new AppPerfInstanceQuery();
                            appPerfInstanceQuery.setAppPerfId(testCase.getId());
                            List appPerfInstanceList = this.appPerfInstanceService.findAppPerfInstanceList(appPerfInstanceQuery);
                            if (appPerfInstanceList != null && appPerfInstanceList.size() > 0) {
                                AppPerfInstance appPerfInstance = (AppPerfInstance)appPerfInstanceList.get(0);
                                recentInstance.put("result", appPerfInstance.getResult());
                                recentInstance.put("instanceId", appPerfInstance.getId());
                                recentInstance.put("executeNumber", appPerfInstance.getExecuteNumber());
                                break;
                            }
                            recentInstance.put("result", 2);
                            recentInstance.put("instanceId", null);
                            recentInstance.put("executeNumber", null);
                            break;
                        }
                    }
                } else {
                    recentInstance.put("result", 2);
                    recentInstance.put("instanceId", null);
                    recentInstance.put("executeNumber", null);
                }
                testCase.setRecentInstance(recentInstance);
                newTestCaseList.add(testCase);
            }
        }
        return newTestCaseList;
    }
}

