/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.test.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.repository.model.Repository;
import io.tiklab.teston.repository.service.RepositoryService;
import io.tiklab.teston.test.test.dao.TestCaseRecentDao;
import io.tiklab.teston.test.test.entity.TestCaseRecentEntity;
import io.tiklab.teston.test.test.model.TestCase;
import io.tiklab.teston.test.test.model.TestCaseRecent;
import io.tiklab.teston.test.test.model.TestCaseRecentQuery;
import io.tiklab.teston.test.test.service.TestCaseRecentService;
import io.tiklab.teston.test.test.service.TestCaseService;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class TestCaseRecentServiceImpl
implements TestCaseRecentService {
    @Autowired
    TestCaseRecentDao testCaseRecentDao;
    @Autowired
    TestCaseService testCaseService;
    @Autowired
    RepositoryService repositoryService;
    @Autowired
    JoinTemplate joinTemplate;

    public String createTestCaseRecent(@NotNull @Valid TestCaseRecent testCaseRecent) {
        TestCaseRecentEntity testCaseRecentEntity = (TestCaseRecentEntity)BeanMapper.map((Object)testCaseRecent, TestCaseRecentEntity.class);
        return this.testCaseRecentDao.createTestCaseRecent(testCaseRecentEntity);
    }

    public void updateTestCaseRecent(@NotNull @Valid TestCaseRecent testCaseRecent) {
        TestCaseRecentEntity testCaseRecentEntity = (TestCaseRecentEntity)BeanMapper.map((Object)testCaseRecent, TestCaseRecentEntity.class);
        this.testCaseRecentDao.updateTestCaseRecent(testCaseRecentEntity);
    }

    public void deleteTestCaseRecent(@NotNull String id) {
        this.testCaseRecentDao.deleteTestCaseRecent(id);
    }

    public TestCaseRecent findOne(String id) {
        TestCaseRecentEntity testCaseRecentEntity = this.testCaseRecentDao.findTestCaseRecent(id);
        TestCaseRecent testCaseRecent = (TestCaseRecent)BeanMapper.map((Object)testCaseRecentEntity, TestCaseRecent.class);
        return testCaseRecent;
    }

    public List<TestCaseRecent> findList(List<String> idList) {
        List<TestCaseRecentEntity> testCaseRecentEntityList = this.testCaseRecentDao.findTestCaseRecentList(idList);
        List testCaseRecentList = BeanMapper.mapList(testCaseRecentEntityList, TestCaseRecent.class);
        return testCaseRecentList;
    }

    public TestCaseRecent findTestCaseRecent(@NotNull String id) {
        TestCaseRecent testCaseRecent = this.findOne(id);
        this.joinTemplate.joinQuery((Object)testCaseRecent);
        return testCaseRecent;
    }

    public List<TestCaseRecent> findAllTestCaseRecent() {
        List<TestCaseRecentEntity> testCaseRecentEntityList = this.testCaseRecentDao.findAllTestCaseRecent();
        List testCaseRecentList = BeanMapper.mapList(testCaseRecentEntityList, TestCaseRecent.class);
        this.joinTemplate.joinQuery(testCaseRecentList);
        return testCaseRecentList;
    }

    public List<TestCaseRecent> findTestCaseRecentList(TestCaseRecentQuery testCaseRecentQuery) {
        List<TestCaseRecentEntity> testCaseRecentEntityList = this.testCaseRecentDao.findTestCaseRecentList(testCaseRecentQuery);
        List testCaseRecentList = BeanMapper.mapList(testCaseRecentEntityList, TestCaseRecent.class);
        if (testCaseRecentList != null && testCaseRecentList.size() > 0) {
            for (TestCaseRecent testCaseRecent : testCaseRecentList) {
                TestCase testCase = this.testCaseService.findTestCase(testCaseRecent.getTestCase().getId());
                testCaseRecent.setTestCase(testCase);
                Repository repository = this.repositoryService.findRepository(testCaseRecent.getRepository().getId());
                testCaseRecent.setRepository(repository);
            }
        }
        return testCaseRecentList;
    }

    public Pagination<TestCaseRecent> findTestCaseRecentPage(TestCaseRecentQuery testCaseRecentQuery) {
        Pagination<TestCaseRecentEntity> pagination = this.testCaseRecentDao.findTestCaseRecentPage(testCaseRecentQuery);
        List testCaseRecentList = BeanMapper.mapList((List)pagination.getDataList(), TestCaseRecent.class);
        this.joinTemplate.joinQuery(testCaseRecentList);
        return PaginationBuilder.build(pagination, (List)testCaseRecentList);
    }

    public void testCaseRecent(TestCaseRecent testCaseRecent) {
        TestCaseRecentQuery testCaseRecentQuery = new TestCaseRecentQuery();
        testCaseRecentQuery.setTestCaseId(testCaseRecent.getTestCase().getId());
        testCaseRecentQuery.setUserId(testCaseRecent.getUser().getId());
        List<TestCaseRecentEntity> testCaseRecentEntityList = this.testCaseRecentDao.findTestCaseRecentList(testCaseRecentQuery);
        List testCaseRecentList = BeanMapper.mapList(testCaseRecentEntityList, TestCaseRecent.class);
        if (CollectionUtils.isNotEmpty((Collection)testCaseRecentList) && testCaseRecentList.size() > 0) {
            TestCaseRecent testCaseRecent1 = (TestCaseRecent)testCaseRecentList.get(0);
            testCaseRecent.setId(testCaseRecent1.getId());
            testCaseRecent.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            this.updateTestCaseRecent(testCaseRecent);
        } else {
            testCaseRecent.setUpdateTime(new Timestamp(System.currentTimeMillis()));
            this.createTestCaseRecent(testCaseRecent);
        }
    }
}

