/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.test.dao;

import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.dal.jpa.criterial.condition.DeleteCondition;
import io.tiklab.dal.jpa.criterial.condition.QueryCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.QueryBuilders;
import io.tiklab.teston.test.test.entity.TestCasesEntity;
import io.tiklab.teston.test.test.model.TestCaseQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class TestCaseDao {
    private static Logger logger = LoggerFactory.getLogger(TestCaseDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createTestCase(TestCasesEntity testCasesEntity) {
        return (String)this.jpaTemplate.save((Object)testCasesEntity, String.class);
    }

    public void updateTestCase(TestCasesEntity testCasesEntity) {
        this.jpaTemplate.update((Object)testCasesEntity);
    }

    public void deleteTestCase(String id) {
        this.jpaTemplate.delete(TestCasesEntity.class, (Object)id);
    }

    public void deleteTestCase(DeleteCondition deleteCondition) {
        this.jpaTemplate.delete(deleteCondition);
    }

    public TestCasesEntity findTestCase(String id) {
        return (TestCasesEntity)this.jpaTemplate.findOne(TestCasesEntity.class, (Object)id);
    }

    public List<TestCasesEntity> findAllTestCase() {
        return this.jpaTemplate.findAll(TestCasesEntity.class);
    }

    public List<TestCasesEntity> findTestCaseList(List<String> idList) {
        return this.jpaTemplate.findList(TestCasesEntity.class, idList);
    }

    public List<TestCasesEntity> findTestCaseList(TestCaseQuery testCaseQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(TestCasesEntity.class).eq("repositoryId", (Object)testCaseQuery.getRepositoryId()).eq("categoryId", (Object)testCaseQuery.getCategoryId()).eq("testType", (Object)testCaseQuery.getTestType()).eq("caseType", (Object)testCaseQuery.getCaseType()).in("repositoryId", (Object[])testCaseQuery.getInList()).notIn("id", (Object[])testCaseQuery.getNotInList()).like("name", (Object)testCaseQuery.getName()).orders(testCaseQuery.getOrderParams()).get();
        return this.jpaTemplate.findList(queryCondition, TestCasesEntity.class);
    }

    public Pagination<TestCasesEntity> findTestCasePage(TestCaseQuery testCaseQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(TestCasesEntity.class).eq("repositoryId", (Object)testCaseQuery.getRepositoryId()).eq("categoryId", (Object)testCaseQuery.getCategoryId()).eq("testType", (Object)testCaseQuery.getTestType()).eq("caseType", (Object)testCaseQuery.getCaseType()).notIn("id", (Object[])testCaseQuery.getNotInList()).in("repositoryId", (Object[])testCaseQuery.getInList()).like("name", (Object)testCaseQuery.getName()).pagination(testCaseQuery.getPageParam()).orders(testCaseQuery.getOrderParams()).get();
        return this.jpaTemplate.findPage(queryCondition, TestCasesEntity.class);
    }
}

