/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.test.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.test.test.model.TestCase;
import io.tiklab.teston.test.test.model.TestCaseQuery;
import io.tiklab.teston.test.test.service.TestCaseService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/testCase"})
@Api(name="TestCaseController", desc="\u6d4b\u8bd5\u7528\u4f8b\u7ba1\u7406")
public class TestCaseController {
    private static Logger logger = LoggerFactory.getLogger(TestCaseController.class);
    @Autowired
    private TestCaseService testCaseService;

    @RequestMapping(path={"/createTestCase"}, method={RequestMethod.POST})
    @ApiMethod(name="createTestCase", desc="\u521b\u5efa\u6d4b\u8bd5\u7528\u4f8b")
    @ApiParam(name="testCase", desc="testCase", required=true)
    public Result<String> createTestCase(@RequestBody @NotNull @Valid TestCase testCase) {
        String id = this.testCaseService.createTestCase(testCase);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateTestCase"}, method={RequestMethod.POST})
    @ApiMethod(name="updateTestCase", desc="\u66f4\u65b0\u6d4b\u8bd5\u7528\u4f8b")
    @ApiParam(name="testCase", desc="testCase", required=true)
    public Result<Void> updateTestCase(@RequestBody @NotNull @Valid TestCase testCase) {
        this.testCaseService.updateTestCase(testCase);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteTestCase"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteTestCase", desc="\u5220\u9664\u6d4b\u8bd5\u7528\u4f8b")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteTestCase(@NotNull String id) {
        this.testCaseService.deleteTestCase(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findTestCase"}, method={RequestMethod.POST})
    @ApiMethod(name="findTestCase", desc="\u6839\u636eid\u67e5\u627e\u6d4b\u8bd5\u7528\u4f8b")
    @ApiParam(name="id", desc="id", required=true)
    public Result<TestCase> findTestCase(@NotNull String id) {
        TestCase testCase = this.testCaseService.findTestCase(id);
        return Result.ok((Object)testCase);
    }

    @RequestMapping(path={"/findAllTestCase"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllTestCase", desc="\u67e5\u627e\u6240\u6709\u6d4b\u8bd5\u7528\u4f8b")
    public Result<List<TestCase>> findAllTestCase() {
        List testCaseList = this.testCaseService.findAllTestCase();
        return Result.ok((Object)testCaseList);
    }

    @RequestMapping(path={"/findTestCaseList"}, method={RequestMethod.POST})
    @ApiMethod(name="findTestCaseList", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u67e5\u8be2\u6d4b\u8bd5\u7528\u4f8b\u5217\u8868")
    @ApiParam(name="testCaseQuery", desc="testCaseQuery", required=true)
    public Result<List<TestCase>> findTestCaseList(@RequestBody @Valid @NotNull TestCaseQuery testCaseQuery) {
        List testCaseList = this.testCaseService.findTestCaseList(testCaseQuery);
        return Result.ok((Object)testCaseList);
    }

    @RequestMapping(path={"/findTestCasePage"}, method={RequestMethod.POST})
    @ApiMethod(name="findTestCasePage", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u6309\u5206\u9875\u67e5\u8be2\u6d4b\u8bd5\u7528\u4f8b")
    @ApiParam(name="testCaseQuery", desc="testCaseQuery", required=true)
    public Result<Pagination<TestCase>> findTestCasePage(@RequestBody @Valid @NotNull TestCaseQuery testCaseQuery) {
        Pagination pagination = this.testCaseService.findTestCasePage(testCaseQuery);
        return Result.ok((Object)pagination);
    }
}

