/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.func.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.category.model.Category;
import io.tiklab.teston.category.service.CategoryService;
import io.tiklab.teston.test.func.dao.FuncUnitCaseDao;
import io.tiklab.teston.test.func.entity.FuncUnitCaseEntity;
import io.tiklab.teston.test.func.model.FuncUnitCase;
import io.tiklab.teston.test.func.model.FuncUnitCaseQuery;
import io.tiklab.teston.test.func.service.FuncUnitCaseService;
import io.tiklab.teston.test.test.model.TestCase;
import io.tiklab.teston.test.test.model.TestCaseQuery;
import io.tiklab.teston.test.test.service.TestCaseService;
import io.tiklab.user.user.model.User;
import io.tiklab.user.user.service.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class FuncUnitCaseServiceImpl
implements FuncUnitCaseService {
    @Autowired
    FuncUnitCaseDao funcUnitCaseDao;
    @Autowired
    TestCaseService testCaseService;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    CategoryService categoryService;
    @Autowired
    UserService userService;

    public String createFuncUnitCase(@NotNull @Valid FuncUnitCase funcUnitCase) {
        FuncUnitCaseEntity funcUnitCaseEntity = (FuncUnitCaseEntity)BeanMapper.map((Object)funcUnitCase, FuncUnitCaseEntity.class);
        String id = this.funcUnitCaseDao.createFuncUnitCase(funcUnitCaseEntity);
        funcUnitCaseEntity.setTestCaseId(id);
        funcUnitCaseEntity.setId(id);
        this.funcUnitCaseDao.updateFuncUnitCase(funcUnitCaseEntity);
        TestCase testCase = funcUnitCase.getTestCase();
        testCase.setId(id);
        this.testCaseService.createTestCase(testCase);
        return id;
    }

    public void updateFuncUnitCase(@NotNull @Valid FuncUnitCase funcUnitCase) {
        FuncUnitCaseEntity funcUnitCaseEntity = (FuncUnitCaseEntity)BeanMapper.map((Object)funcUnitCase, FuncUnitCaseEntity.class);
        this.funcUnitCaseDao.updateFuncUnitCase(funcUnitCaseEntity);
        this.testCaseService.updateTestCase(funcUnitCase.getTestCase());
    }

    public void deleteFuncUnitCase(@NotNull String id) {
        this.funcUnitCaseDao.deleteFuncUnitCase(id);
        this.testCaseService.deleteTestCase(id);
    }

    public FuncUnitCase findOne(String id) {
        FuncUnitCaseEntity funcUnitCaseEntity = this.funcUnitCaseDao.findFuncUnitCase(id);
        FuncUnitCase funcUnitCase = (FuncUnitCase)BeanMapper.map((Object)funcUnitCaseEntity, FuncUnitCase.class);
        return funcUnitCase;
    }

    public List<FuncUnitCase> findList(List<String> idList) {
        List<FuncUnitCaseEntity> funcUnitCaseEntityList = this.funcUnitCaseDao.findFuncUnitCaseList(idList);
        List funcUnitCaseList = BeanMapper.mapList(funcUnitCaseEntityList, FuncUnitCase.class);
        return funcUnitCaseList;
    }

    public FuncUnitCase findFuncUnitCase(@NotNull String id) {
        FuncUnitCase funcUnitCase = this.findOne(id);
        this.joinTemplate.joinQuery((Object)funcUnitCase);
        TestCase testCase = funcUnitCase.getTestCase();
        if (testCase.getCategory() != null) {
            Category category = this.categoryService.findCategory(testCase.getCategory().getId());
            funcUnitCase.getTestCase().setCategory(category);
        }
        if (testCase.getUpdateUser() != null) {
            User updateUser = this.userService.findUser(testCase.getUpdateUser().getId());
            funcUnitCase.getTestCase().setUpdateUser(updateUser);
        }
        return funcUnitCase;
    }

    public List<FuncUnitCase> findAllFuncUnitCase() {
        List<FuncUnitCaseEntity> funcUnitCaseEntityList = this.funcUnitCaseDao.findAllFuncUnitCase();
        List funcUnitCaseList = BeanMapper.mapList(funcUnitCaseEntityList, FuncUnitCase.class);
        this.joinTemplate.joinQuery(funcUnitCaseList);
        return funcUnitCaseList;
    }

    public List<FuncUnitCase> findFuncUnitCaseList(FuncUnitCaseQuery functionTestCaseQuery) {
        List<FuncUnitCaseEntity> funcUnitCaseEntityList = this.funcUnitCaseDao.findFuncUnitCaseList(functionTestCaseQuery);
        List funcUnitCaseList = BeanMapper.mapList(funcUnitCaseEntityList, FuncUnitCase.class);
        this.joinTemplate.joinQuery(funcUnitCaseList);
        return funcUnitCaseList;
    }

    public Pagination<FuncUnitCase> findFuncUnitCasePage(FuncUnitCaseQuery functionTestCaseQuery) {
        Pagination<FuncUnitCaseEntity> pagination = this.funcUnitCaseDao.findFuncUnitCasePage(functionTestCaseQuery);
        List funcUnitCaseList = BeanMapper.mapList((List)pagination.getDataList(), FuncUnitCase.class);
        this.joinTemplate.joinQuery(funcUnitCaseList);
        return PaginationBuilder.build(pagination, (List)funcUnitCaseList);
    }

    public List<FuncUnitCase> findFuncUnitCaseListByTestCase(TestCaseQuery testCaseQuery) {
        List testCaseList = this.testCaseService.findTestCaseList(testCaseQuery);
        ArrayList<FuncUnitCase> funcUnitCaseList = new ArrayList<FuncUnitCase>();
        if (CollectionUtils.isNotEmpty((Collection)testCaseList)) {
            for (TestCase testCase : testCaseList) {
                FuncUnitCase funcUnitCase = this.findFuncUnitCase(testCase.getId());
                if (ObjectUtils.isEmpty((Object)funcUnitCase)) continue;
                funcUnitCaseList.add(funcUnitCase);
            }
        }
        return funcUnitCaseList;
    }
}

