/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.app.scene.instance.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.app.scene.execute.model.AppSceneTestResponse;
import io.tiklab.teston.test.app.scene.instance.dao.AppSceneInstanceDao;
import io.tiklab.teston.test.app.scene.instance.entity.AppSceneInstanceEntity;
import io.tiklab.teston.test.app.scene.instance.model.AppSceneInstance;
import io.tiklab.teston.test.app.scene.instance.model.AppSceneInstanceQuery;
import io.tiklab.teston.test.app.scene.instance.model.AppSceneInstanceStep;
import io.tiklab.teston.test.app.scene.instance.model.AppSceneInstanceStepQuery;
import io.tiklab.teston.test.app.scene.instance.service.AppSceneInstanceService;
import io.tiklab.teston.test.app.scene.instance.service.AppSceneInstanceStepService;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppSceneInstanceServiceImpl
implements AppSceneInstanceService {
    @Autowired
    AppSceneInstanceDao appSceneInstanceDao;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    AppSceneInstanceStepService appSceneInstanceStepService;

    public String createAppSceneInstance(@NotNull @Valid AppSceneInstance appSceneInstance) {
        AppSceneInstanceEntity appSceneInstanceEntity = (AppSceneInstanceEntity)BeanMapper.map((Object)appSceneInstance, AppSceneInstanceEntity.class);
        appSceneInstanceEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return this.appSceneInstanceDao.createAppSceneInstance(appSceneInstanceEntity);
    }

    public void updateAppSceneInstance(@NotNull @Valid AppSceneInstance appSceneInstance) {
        AppSceneInstanceEntity appSceneInstanceEntity = (AppSceneInstanceEntity)BeanMapper.map((Object)appSceneInstance, AppSceneInstanceEntity.class);
        this.appSceneInstanceDao.updateAppSceneInstance(appSceneInstanceEntity);
    }

    public void deleteAppSceneInstance(@NotNull String id) {
        this.appSceneInstanceDao.deleteAppSceneInstance(id);
    }

    public AppSceneInstance findOne(String id) {
        AppSceneInstanceEntity appSceneInstanceEntity = this.appSceneInstanceDao.findAppSceneInstance(id);
        AppSceneInstance appSceneInstance = (AppSceneInstance)BeanMapper.map((Object)appSceneInstanceEntity, AppSceneInstance.class);
        return appSceneInstance;
    }

    public List<AppSceneInstance> findList(List<String> idList) {
        List<AppSceneInstanceEntity> appSceneInstanceEntityList = this.appSceneInstanceDao.findAppSceneInstanceList(idList);
        List appSceneInstanceList = BeanMapper.mapList(appSceneInstanceEntityList, AppSceneInstance.class);
        return appSceneInstanceList;
    }

    public AppSceneInstance findAppSceneInstance(@NotNull String id) {
        AppSceneInstance appSceneInstance = this.findOne(id);
        List appSceneInstanceStepList = this.appSceneInstanceStepService.findAppSceneInstanceStepList(new AppSceneInstanceStepQuery().setAppSceneInstanceId(id));
        appSceneInstance.setStepList(appSceneInstanceStepList);
        this.joinTemplate.joinQuery((Object)appSceneInstance);
        return appSceneInstance;
    }

    public List<AppSceneInstance> findAllAppSceneInstance() {
        List<AppSceneInstanceEntity> appSceneInstanceEntities = this.appSceneInstanceDao.findAllAppSceneInstance();
        List appSceneInstanceList = BeanMapper.mapList(appSceneInstanceEntities, AppSceneInstance.class);
        this.joinTemplate.joinQuery(appSceneInstanceList);
        return appSceneInstanceList;
    }

    public List<AppSceneInstance> findAppSceneInstanceList(AppSceneInstanceQuery appSceneInstanceQuery) {
        List<AppSceneInstanceEntity> appSceneInstanceEntities = this.appSceneInstanceDao.findAppSceneInstanceList(appSceneInstanceQuery);
        List appSceneInstanceList = BeanMapper.mapList(appSceneInstanceEntities, AppSceneInstance.class);
        this.joinTemplate.joinQuery(appSceneInstanceList);
        return appSceneInstanceList;
    }

    public Pagination<AppSceneInstance> findAppSceneInstancePage(AppSceneInstanceQuery appSceneInstanceQuery) {
        Pagination<AppSceneInstanceEntity> pagination = this.appSceneInstanceDao.findAppSceneInstancePage(appSceneInstanceQuery);
        List appSceneInstanceList = BeanMapper.mapList((List)pagination.getDataList(), AppSceneInstance.class);
        this.joinTemplate.joinQuery(appSceneInstanceList);
        return PaginationBuilder.build(pagination, (List)appSceneInstanceList);
    }

    public String saveAppSceneInstanceToSql(AppSceneInstance appSceneInstance, AppSceneTestResponse appSceneTestResponse) {
        String appSceneInstanceId = this.createAppSceneInstance(appSceneInstance);
        if (CollectionUtils.isNotEmpty((Collection)appSceneTestResponse.getAppSceneInstanceStepList())) {
            for (AppSceneInstanceStep appSceneInstanceStep : appSceneTestResponse.getAppSceneInstanceStepList()) {
                appSceneInstanceStep.setAppSceneInstanceId(appSceneInstanceId);
                this.appSceneInstanceStepService.createAppSceneInstanceStep(appSceneInstanceStep);
            }
        }
        return appSceneInstanceId;
    }
}

