/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.app.scene.execute.service;

import io.tiklab.rpc.client.router.lookup.FixedLookup;
import io.tiklab.rpc.client.router.lookup.Lookup;
import io.tiklab.teston.agent.app.scene.AppSceneTestService;
import io.tiklab.teston.support.agentconfig.model.AgentConfig;
import io.tiklab.teston.support.agentconfig.model.AgentConfigQuery;
import io.tiklab.teston.support.agentconfig.service.AgentConfigService;
import io.tiklab.teston.support.environment.service.AppEnvService;
import io.tiklab.teston.test.app.scene.cases.model.AppSceneStepQuery;
import io.tiklab.teston.test.app.scene.cases.service.AppSceneStepService;
import io.tiklab.teston.test.app.scene.execute.model.AppSceneTestRequest;
import io.tiklab.teston.test.app.scene.execute.model.AppSceneTestResponse;
import io.tiklab.teston.test.app.scene.execute.service.AppSceneTestDispatchService;
import io.tiklab.teston.test.app.scene.instance.model.AppSceneInstance;
import io.tiklab.teston.test.app.scene.instance.model.AppSceneInstanceQuery;
import io.tiklab.teston.test.app.scene.instance.service.AppSceneInstanceService;
import io.tiklab.teston.test.app.utils.RpcClientAppUtil;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AppSceneTestDispatchServiceImpl
implements AppSceneTestDispatchService {
    private static Logger logger = LoggerFactory.getLogger(AppSceneTestDispatchServiceImpl.class);
    @Autowired
    AppSceneStepService appSceneStepService;
    @Autowired
    AppSceneInstanceService appSceneInstanceService;
    @Autowired
    AgentConfigService agentConfigService;
    @Autowired
    AppEnvService appEnvService;
    @Autowired
    RpcClientAppUtil rpcClientAppUtil;
    @Autowired
    AppSceneTestService appSceneTestService;
    @Value(value="${teston-agent.embbed.enable:false}")
    Boolean enable;
    private AgentConfig agentConfig = null;
    private Integer status;

    AppSceneTestService appSceneTestServiceRPC(String agentUrl) {
        return (AppSceneTestService)this.rpcClientAppUtil.rpcClient().getBean(AppSceneTestService.class, (Lookup)new FixedLookup(agentUrl));
    }

    public Integer execute(AppSceneTestRequest appSceneTestRequest) {
        String appSceneId = appSceneTestRequest.getAppSceneId();
        AppSceneStepQuery appSceneStepQuery = new AppSceneStepQuery();
        appSceneStepQuery.setAppSceneId(appSceneId);
        List appSceneStepList = this.appSceneStepService.findAppSceneStepList(appSceneStepQuery);
        appSceneTestRequest.setAppSceneStepList(appSceneStepList);
        if (this.enable.booleanValue()) {
            this.appSceneTestService.execute(appSceneTestRequest);
        } else {
            List agentConfigList = this.agentConfigService.findAgentConfigList(new AgentConfigQuery());
            if (CollectionUtils.isNotEmpty((Collection)agentConfigList)) {
                AgentConfig agentConfig = (AgentConfig)agentConfigList.get(0);
                this.appSceneTestServiceRPC(agentConfig.getUrl()).execute(appSceneTestRequest);
            }
        }
        this.status = 1;
        return this.status;
    }

    public Integer status() {
        if (this.enable.booleanValue()) {
            this.status = this.appSceneTestService.status();
        } else {
            List agentConfigList = this.agentConfigService.findAgentConfigList(new AgentConfigQuery());
            if (CollectionUtils.isNotEmpty((Collection)agentConfigList)) {
                this.agentConfig = (AgentConfig)agentConfigList.get(0);
                this.status = this.appSceneTestServiceRPC(this.agentConfig.getUrl()).status();
            }
        }
        return this.status;
    }

    public AppSceneTestResponse result(AppSceneTestRequest appSceneTestRequest) {
        AppSceneTestResponse appSceneTestResponse = this.enable != false ? this.appSceneTestService.result() : this.appSceneTestServiceRPC(this.agentConfig.getUrl()).result();
        String appSceneId = appSceneTestRequest.getAppSceneId();
        this.saveToSQL(appSceneTestResponse, appSceneId);
        return appSceneTestResponse;
    }

    private void saveToSQL(AppSceneTestResponse appSceneTestResponse, String appSceneId) {
        AppSceneInstance appSceneInstance = appSceneTestResponse.getAppSceneInstance();
        appSceneInstance.setAppSceneId(appSceneId);
        AppSceneInstanceQuery appSceneInstanceQuery = new AppSceneInstanceQuery();
        appSceneInstanceQuery.setAppSceneId(appSceneId);
        List appSceneInstanceList = this.appSceneInstanceService.findAppSceneInstanceList(appSceneInstanceQuery);
        if (appSceneInstanceList != null && appSceneInstanceList.size() > 0) {
            Integer executeNumber = ((AppSceneInstance)appSceneInstanceList.get(0)).getExecuteNumber();
            executeNumber = executeNumber + 1;
            appSceneInstance.setExecuteNumber(executeNumber);
        } else {
            appSceneInstance.setExecuteNumber(Integer.valueOf(1));
        }
        this.appSceneInstanceService.saveAppSceneInstanceToSql(appSceneInstance, appSceneTestResponse);
    }
}

