/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.app.scene.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.category.model.Category;
import io.tiklab.teston.category.service.CategoryService;
import io.tiklab.teston.test.app.scene.cases.dao.AppSceneCaseDao;
import io.tiklab.teston.test.app.scene.cases.entity.AppSceneCaseEntity;
import io.tiklab.teston.test.app.scene.cases.model.AppSceneCase;
import io.tiklab.teston.test.app.scene.cases.model.AppSceneCaseQuery;
import io.tiklab.teston.test.app.scene.cases.service.AppSceneCaseService;
import io.tiklab.teston.test.test.model.TestCase;
import io.tiklab.teston.test.test.model.TestCaseQuery;
import io.tiklab.teston.test.test.service.TestCaseService;
import io.tiklab.user.user.model.User;
import io.tiklab.user.user.service.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppSceneCaseServiceImpl
implements AppSceneCaseService {
    @Autowired
    AppSceneCaseDao appSceneCaseDao;
    @Autowired
    TestCaseService testCaseService;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    CategoryService categoryService;
    @Autowired
    UserService userService;

    public String createAppSceneCase(@NotNull @Valid AppSceneCase appSceneCase) {
        AppSceneCaseEntity appSceneCaseEntity = (AppSceneCaseEntity)BeanMapper.map((Object)appSceneCase, AppSceneCaseEntity.class);
        String id = this.appSceneCaseDao.createAppSceneCase(appSceneCaseEntity);
        appSceneCaseEntity.setTestCaseId(id);
        appSceneCaseEntity.setId(id);
        this.appSceneCaseDao.updateAppSceneCase(appSceneCaseEntity);
        TestCase testCase = appSceneCase.getTestCase();
        testCase.setId(id);
        this.testCaseService.createTestCase(testCase);
        return id;
    }

    public void updateAppSceneCase(@NotNull @Valid AppSceneCase appSceneCase) {
        AppSceneCaseEntity appSceneCaseEntity = (AppSceneCaseEntity)BeanMapper.map((Object)appSceneCase, AppSceneCaseEntity.class);
        this.appSceneCaseDao.updateAppSceneCase(appSceneCaseEntity);
        this.testCaseService.updateTestCase(appSceneCase.getTestCase());
    }

    public void deleteAppSceneCase(@NotNull String id) {
        this.appSceneCaseDao.deleteAppSceneCase(id);
        this.testCaseService.deleteTestCase(id);
    }

    public AppSceneCase findOne(String id) {
        AppSceneCaseEntity appSceneCaseEntity = this.appSceneCaseDao.findAppSceneCase(id);
        AppSceneCase appSceneCase = (AppSceneCase)BeanMapper.map((Object)appSceneCaseEntity, AppSceneCase.class);
        return appSceneCase;
    }

    public List<AppSceneCase> findList(List<String> idList) {
        List<AppSceneCaseEntity> appSceneCaseEntityList = this.appSceneCaseDao.findAppSceneCaseList(idList);
        List appSceneCaseList = BeanMapper.mapList(appSceneCaseEntityList, AppSceneCase.class);
        return appSceneCaseList;
    }

    public AppSceneCase findAppSceneCase(@NotNull String id) {
        AppSceneCase appSceneCase = this.findOne(id);
        this.joinTemplate.joinQuery((Object)appSceneCase);
        TestCase testCase = appSceneCase.getTestCase();
        if (testCase.getCategory() != null) {
            Category category = this.categoryService.findCategory(testCase.getCategory().getId());
            appSceneCase.getTestCase().setCategory(category);
        }
        if (testCase.getUpdateUser() != null) {
            User updateUser = this.userService.findUser(testCase.getUpdateUser().getId());
            appSceneCase.getTestCase().setUpdateUser(updateUser);
        }
        return appSceneCase;
    }

    public List<AppSceneCase> findAllAppSceneCase() {
        List<AppSceneCaseEntity> appSceneCaseEntityList = this.appSceneCaseDao.findAllAppSceneCase();
        List appSceneCaseList = BeanMapper.mapList(appSceneCaseEntityList, AppSceneCase.class);
        this.joinTemplate.joinQuery(appSceneCaseList);
        return appSceneCaseList;
    }

    public List<AppSceneCase> findAppSceneCaseList(AppSceneCaseQuery appSceneCaseQuery) {
        List<AppSceneCaseEntity> appSceneCaseEntityList = this.appSceneCaseDao.findAppSceneCaseList(appSceneCaseQuery);
        List appSceneCaseList = BeanMapper.mapList(appSceneCaseEntityList, AppSceneCase.class);
        this.joinTemplate.joinQuery(appSceneCaseList);
        return appSceneCaseList;
    }

    public Pagination<AppSceneCase> findAppSceneCasePage(AppSceneCaseQuery appSceneCaseQuery) {
        Pagination<AppSceneCaseEntity> pagination = this.appSceneCaseDao.findAppSceneCasePage(appSceneCaseQuery);
        List appSceneCaseList = BeanMapper.mapList((List)pagination.getDataList(), AppSceneCase.class);
        this.joinTemplate.joinQuery(appSceneCaseList);
        return PaginationBuilder.build(pagination, (List)appSceneCaseList);
    }

    public List<AppSceneCase> findAppSceneCaseListByTestCase(TestCaseQuery testCaseQuery) {
        List testCaseList = this.testCaseService.findTestCaseList(testCaseQuery);
        ArrayList<AppSceneCase> appSceneCaseList = new ArrayList<AppSceneCase>();
        if (CollectionUtils.isNotEmpty((Collection)testCaseList)) {
            for (TestCase testCase : testCaseList) {
                AppSceneCase appSceneCase = this.findAppSceneCase(testCase.getId());
                appSceneCaseList.add(appSceneCase);
            }
        }
        return appSceneCaseList;
    }
}

