/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.app.perf.execute.service;

import io.tiklab.rpc.client.router.lookup.FixedLookup;
import io.tiklab.rpc.client.router.lookup.Lookup;
import io.tiklab.teston.agent.app.perf.AppPerfTestService;
import io.tiklab.teston.support.agentconfig.model.AgentConfig;
import io.tiklab.teston.support.agentconfig.model.AgentConfigQuery;
import io.tiklab.teston.support.agentconfig.service.AgentConfigService;
import io.tiklab.teston.test.app.perf.cases.model.AppPerfCase;
import io.tiklab.teston.test.app.perf.cases.model.AppPerfStep;
import io.tiklab.teston.test.app.perf.cases.model.AppPerfStepQuery;
import io.tiklab.teston.test.app.perf.cases.service.AppPerfCaseService;
import io.tiklab.teston.test.app.perf.cases.service.AppPerfStepService;
import io.tiklab.teston.test.app.perf.execute.mode.AppPerfTestRequest;
import io.tiklab.teston.test.app.perf.execute.mode.AppPerfTestResponse;
import io.tiklab.teston.test.app.perf.execute.service.AppPerfTestDispatchService;
import io.tiklab.teston.test.app.perf.instance.mode.AppPerfInstance;
import io.tiklab.teston.test.app.perf.instance.mode.AppPerfInstanceQuery;
import io.tiklab.teston.test.app.perf.instance.service.AppPerfInstanceService;
import io.tiklab.teston.test.app.scene.cases.model.AppSceneStepQuery;
import io.tiklab.teston.test.app.scene.cases.service.AppSceneStepService;
import io.tiklab.teston.test.app.scene.execute.model.AppSceneTestRequest;
import io.tiklab.teston.test.app.scene.execute.model.AppTestConfig;
import io.tiklab.teston.test.app.scene.instance.model.AppSceneInstance;
import io.tiklab.teston.test.app.utils.RpcClientAppUtil;
import io.tiklab.teston.test.app.utils.TestAppUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class AppPerfTestDispatchServiceImpl
implements AppPerfTestDispatchService {
    private static Logger logger = LoggerFactory.getLogger(AppPerfTestDispatchServiceImpl.class);
    @Autowired
    AppSceneStepService appSceneStepService;
    @Autowired
    AppPerfCaseService appPerfCaseService;
    @Autowired
    AppPerfStepService appPerfStepService;
    @Autowired
    AppPerfInstanceService appPerfInstanceService;
    @Autowired
    AgentConfigService agentConfigService;
    @Autowired
    RpcClientAppUtil rpcClientAppUtil;
    @Autowired
    TestAppUtil testAppUtil;
    @Autowired
    AppPerfTestService appPerfTestService;
    @Value(value="${teston-agent.embbed.enable:false}")
    Boolean enable;
    private List<AgentConfig> agentConfigList;
    private Integer executeCount;
    public Integer status = 0;
    private String appPerfInstanceId;

    AppPerfTestService appPerfTestServiceRPC(String agentUrl) {
        return (AppPerfTestService)this.rpcClientAppUtil.rpcClient().getBean(AppPerfTestService.class, (Lookup)new FixedLookup(agentUrl));
    }

    public void execute(AppPerfTestRequest appPerfTestRequest) {
        this.appPerfInstanceId = null;
        AppTestConfig appTestConfig = new AppTestConfig();
        appTestConfig.setPlatformName("Android");
        appTestConfig.setAppiumSever("127.0.0.1:4723");
        appTestConfig.setAppPackage("com.tencent.mobileqq");
        appTestConfig.setAppActivity("com.tencent.mobileqq.activity.SplashActivity");
        appTestConfig.setDeviceName("127.0.0.1:62001");
        AppTestConfig appTestConfig1 = new AppTestConfig();
        appTestConfig1.setPlatformName("Android");
        appTestConfig1.setAppiumSever("192.168.10.18:4724");
        appTestConfig1.setAppPackage("com.tencent.mobileqq");
        appTestConfig1.setAppActivity("com.tencent.mobileqq.activity.SplashActivity");
        appTestConfig1.setDeviceName("127.0.0.1:62025");
        AppTestConfig appTestConfig2 = new AppTestConfig();
        appTestConfig2.setPlatformName("Android");
        appTestConfig2.setAppiumSever("192.168.10.18:4725");
        appTestConfig2.setAppPackage("com.tencent.mobileqq");
        appTestConfig2.setAppActivity("com.tencent.mobileqq.activity.SplashActivity");
        appTestConfig2.setDeviceName("127.0.0.1:62026");
        ArrayList<AppTestConfig> appTestConfigList = new ArrayList<AppTestConfig>();
        appTestConfigList.add(appTestConfig);
        appTestConfigList.add(appTestConfig1);
        appTestConfigList.add(appTestConfig2);
        appPerfTestRequest.setAppTestConfigList(appTestConfigList);
        String appPerfId = appPerfTestRequest.getAppPerfId();
        AppPerfCase appPerfCase = this.appPerfCaseService.findAppPerfCase(appPerfTestRequest.getAppPerfId());
        appPerfTestRequest.setAppPerfCase(appPerfCase);
        AppPerfStepQuery appPerfStepQuery = new AppPerfStepQuery();
        appPerfStepQuery.setAppPerfId(appPerfId);
        List appPerfStepList = this.appPerfStepService.findAppPerfStepList(appPerfStepQuery);
        List<AppSceneTestRequest> appSceneTestRequestList = this.processExeData(appPerfStepList, appTestConfig);
        appPerfTestRequest.setAppSceneTestRequestList(appSceneTestRequestList);
        this.executeCount = appPerfCase.getExecuteCount();
        this.agentConfigList = this.agentConfigService.findAgentConfigList(new AgentConfigQuery());
        int agentSize = this.agentConfigList.size();
        Integer executeType = appPerfCase.getExecuteType();
        List<Object> distributionList = new ArrayList();
        if (executeType == 1) {
            logger.info("--------------------------------------loop-----------------------------------");
            distributionList = this.testAppUtil.loop(this.executeCount, agentSize);
        }
        if (executeType == 2) {
            distributionList = this.testAppUtil.random(this.executeCount, agentSize);
        }
        for (int i = 0; i < agentSize; ++i) {
            appPerfTestRequest.setExeNum((Integer)distributionList.get(i));
            appPerfTestRequest.setAppTestConfig((AppTestConfig)appTestConfigList.get(i));
            AgentConfig agentConfig = this.agentConfigList.get(i);
            appPerfTestRequest.setCurrentAgentId(agentConfig.getId());
            if (this.enable.booleanValue()) {
                this.appPerfTestService.execute(appPerfTestRequest);
                continue;
            }
            this.appPerfTestServiceRPC(agentConfig.getUrl()).execute(appPerfTestRequest);
        }
    }

    public AppPerfTestResponse exeResult(AppPerfTestRequest appPerfTestRequest) {
        AppPerfTestResponse appPerfTestResponse = new AppPerfTestResponse();
        ArrayList arrayList = new ArrayList();
        for (int i = 0; i < this.agentConfigList.size(); ++i) {
            AppPerfTestResponse response = this.enable != false ? this.appPerfTestService.exeResult(appPerfTestRequest) : this.appPerfTestServiceRPC(this.agentConfigList.get(i).getUrl()).exeResult(appPerfTestRequest);
            if (!CollectionUtils.isNotEmpty((Collection)response.getAppSceneInstanceList())) continue;
            arrayList.addAll(response.getAppSceneInstanceList());
        }
        appPerfTestResponse.setAppSceneInstanceList(arrayList);
        this.status = appPerfTestResponse.getAppSceneInstanceList().size() == this.executeCount.intValue() ? Integer.valueOf(2) : Integer.valueOf(1);
        AppPerfInstance appPerfInstance = this.processPerfTestData(appPerfTestResponse);
        appPerfTestResponse.setAppPerfInstance(appPerfInstance);
        if (appPerfTestRequest.getExeType() == null) {
            String appPerfId = appPerfTestRequest.getAppPerfId();
            appPerfInstance.setAppPerfId(appPerfId);
            if (this.appPerfInstanceId == null) {
                AppPerfInstanceQuery appPerfInstanceQuery = new AppPerfInstanceQuery();
                appPerfInstanceQuery.setAppPerfId(appPerfId);
                List appPerfInstanceList = this.appPerfInstanceService.findAppPerfInstanceList(appPerfInstanceQuery);
                if (appPerfInstanceList != null && appPerfInstanceList.size() > 0) {
                    Integer executeNumber = ((AppPerfInstance)appPerfInstanceList.get(0)).getExecuteNumber();
                    executeNumber = executeNumber + 1;
                    appPerfInstance.setExecuteNumber(executeNumber);
                } else {
                    appPerfInstance.setExecuteNumber(Integer.valueOf(1));
                }
                this.appPerfInstanceId = this.appPerfInstanceService.createAppPerfInstance(appPerfInstance);
            } else {
                appPerfInstance.setId(this.appPerfInstanceId);
                this.appPerfInstanceService.updateAppPerfInstance(appPerfInstance);
            }
        }
        return appPerfTestResponse;
    }

    private AppPerfInstance processPerfTestData(AppPerfTestResponse appPerfTestResponse) {
        AppPerfInstance appPerfInstance = new AppPerfInstance();
        int size = appPerfTestResponse.getAppSceneInstanceList().size();
        appPerfInstance.setTotal(Integer.valueOf(size));
        int passNum = 0;
        for (AppSceneInstance appSceneInstance : appPerfTestResponse.getAppSceneInstanceList()) {
            if (!appSceneInstance.getResult().equals(1)) continue;
            ++passNum;
        }
        appPerfInstance.setPassNum(Integer.valueOf(passNum));
        appPerfInstance.setPassRate(this.testAppUtil.processRate(passNum, size));
        appPerfInstance.setFailNum(Integer.valueOf(size - passNum));
        appPerfInstance.setErrorRate(this.testAppUtil.processRate(size - passNum, size));
        if (size == passNum) {
            appPerfInstance.setResult(Integer.valueOf(1));
        } else {
            appPerfInstance.setResult(Integer.valueOf(0));
        }
        return appPerfInstance;
    }

    private List<AppSceneTestRequest> processExeData(List<AppPerfStep> appPerfStepList, AppTestConfig appTestConfig) {
        ArrayList<AppSceneTestRequest> appSceneTestRequestList = new ArrayList<AppSceneTestRequest>();
        if (CollectionUtils.isNotEmpty(appPerfStepList)) {
            for (AppPerfStep appPerfStep : appPerfStepList) {
                AppSceneTestRequest appSceneTestRequest = new AppSceneTestRequest();
                AppSceneStepQuery appSceneStepQuery = new AppSceneStepQuery();
                appSceneStepQuery.setAppSceneId(appPerfStep.getAppScene().getId());
                List appSceneStepList = this.appSceneStepService.findAppSceneStepList(appSceneStepQuery);
                appSceneTestRequest.setAppSceneStepList(appSceneStepList);
                appSceneTestRequest.setAppTestConfig(appTestConfig);
                appSceneTestRequestList.add(appSceneTestRequest);
            }
        }
        return appSceneTestRequestList;
    }
}

