/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.app.perf.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.app.perf.cases.dao.AppPerfStepDao;
import io.tiklab.teston.test.app.perf.cases.entity.AppPerfStepEntity;
import io.tiklab.teston.test.app.perf.cases.model.AppPerfStep;
import io.tiklab.teston.test.app.perf.cases.model.AppPerfStepQuery;
import io.tiklab.teston.test.app.perf.cases.service.AppPerfStepService;
import io.tiklab.teston.test.test.model.TestCase;
import io.tiklab.teston.test.test.service.TestCaseService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AppPerfStepServiceImpl
implements AppPerfStepService {
    @Autowired
    AppPerfStepDao appPerfStepDao;
    @Autowired
    TestCaseService testCaseService;
    @Autowired
    JoinTemplate joinTemplate;

    public String createAppPerfStep(@NotNull @Valid AppPerfStep appPerfStep) {
        AppPerfStepEntity appPerfStepEntity = (AppPerfStepEntity)BeanMapper.map((Object)appPerfStep, AppPerfStepEntity.class);
        appPerfStepEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return this.appPerfStepDao.createAppPerfStep(appPerfStepEntity);
    }

    public void updateAppPerfStep(@NotNull @Valid AppPerfStep appPerfStep) {
        AppPerfStepEntity appPerfStepEntity = (AppPerfStepEntity)BeanMapper.map((Object)appPerfStep, AppPerfStepEntity.class);
        this.appPerfStepDao.updateAppPerfStep(appPerfStepEntity);
    }

    public void deleteAppPerfStep(@NotNull String id) {
        this.appPerfStepDao.deleteAppPerfStep(id);
    }

    public AppPerfStep findOne(String id) {
        AppPerfStepEntity appPerfStepEntity = this.appPerfStepDao.findAppPerfStep(id);
        AppPerfStep appPerfStep = (AppPerfStep)BeanMapper.map((Object)appPerfStepEntity, AppPerfStep.class);
        return appPerfStep;
    }

    public List<AppPerfStep> findList(List<String> idList) {
        List<AppPerfStepEntity> appPerfStepEntityList = this.appPerfStepDao.findAppPerfStepList(idList);
        List appPerfStepList = BeanMapper.mapList(appPerfStepEntityList, AppPerfStep.class);
        return appPerfStepList;
    }

    public AppPerfStep findAppPerfStep(@NotNull String id) {
        AppPerfStep appPerfStep = this.findOne(id);
        this.joinTemplate.joinQuery((Object)appPerfStep);
        return appPerfStep;
    }

    public List<AppPerfStep> findAllAppPerfStep() {
        List<AppPerfStepEntity> appPerfStepEntityList = this.appPerfStepDao.findAllAppPerfStep();
        List appPerfStepList = BeanMapper.mapList(appPerfStepEntityList, AppPerfStep.class);
        this.joinTemplate.joinQuery(appPerfStepList);
        return appPerfStepList;
    }

    public List<AppPerfStep> findAppPerfStepList(AppPerfStepQuery appPerfStepQuery) {
        List<AppPerfStepEntity> appPerfStepEntityList = this.appPerfStepDao.findAppPerfStepList(appPerfStepQuery);
        List appPerfStepList = BeanMapper.mapList(appPerfStepEntityList, AppPerfStep.class);
        this.joinTemplate.joinQuery(appPerfStepList);
        ArrayList<AppPerfStep> arrayList = new ArrayList<AppPerfStep>();
        if (appPerfStepList.size() > 0) {
            for (AppPerfStep appPerfStep : appPerfStepList) {
                TestCase testCase = this.testCaseService.findTestCase(appPerfStep.getAppScene().getId());
                appPerfStep.getAppScene().setTestCase(testCase);
                arrayList.add(appPerfStep);
            }
        }
        return arrayList;
    }

    public Pagination<AppPerfStep> findAppPerfStepPage(AppPerfStepQuery appPerfStepQuery) {
        Pagination<AppPerfStepEntity> pagination = this.appPerfStepDao.findAppPerfStepPage(appPerfStepQuery);
        List appPerfStepList = BeanMapper.mapList((List)pagination.getDataList(), AppPerfStep.class);
        this.joinTemplate.joinQuery(appPerfStepList);
        return PaginationBuilder.build(pagination, (List)appPerfStepList);
    }

    public void bindAppScene(List<AppPerfStep> appPerfStepList) {
        if (CollectionUtils.isNotEmpty(appPerfStepList)) {
            for (AppPerfStep appPerfStep : appPerfStepList) {
                this.createAppPerfStep(appPerfStep);
            }
        }
    }
}

