/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.app.perf.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.category.model.Category;
import io.tiklab.teston.category.service.CategoryService;
import io.tiklab.teston.test.app.perf.cases.dao.AppPerfCaseDao;
import io.tiklab.teston.test.app.perf.cases.entity.AppPerfCaseEntity;
import io.tiklab.teston.test.app.perf.cases.model.AppPerfCase;
import io.tiklab.teston.test.app.perf.cases.model.AppPerfCaseQuery;
import io.tiklab.teston.test.app.perf.cases.service.AppPerfCaseService;
import io.tiklab.teston.test.test.model.TestCase;
import io.tiklab.teston.test.test.model.TestCaseQuery;
import io.tiklab.teston.test.test.service.TestCaseService;
import io.tiklab.user.user.model.User;
import io.tiklab.user.user.service.UserService;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class AppPerfCaseServiceImpl
implements AppPerfCaseService {
    @Autowired
    AppPerfCaseDao appPerfCaseDao;
    @Autowired
    TestCaseService testCaseService;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    CategoryService categoryService;
    @Autowired
    UserService userService;

    public String createAppPerfCase(@NotNull @Valid AppPerfCase appPerfCase) {
        AppPerfCaseEntity appPerfCaseEntity = (AppPerfCaseEntity)BeanMapper.map((Object)appPerfCase, AppPerfCaseEntity.class);
        appPerfCaseEntity.setExecuteCount(1);
        appPerfCaseEntity.setExecuteType(1);
        appPerfCaseEntity.setThreadCount(1);
        String id = this.appPerfCaseDao.createAppPerfCase(appPerfCaseEntity);
        appPerfCaseEntity.setTestCaseId(id);
        appPerfCaseEntity.setId(id);
        this.appPerfCaseDao.updateAppPerfCase(appPerfCaseEntity);
        TestCase testCase = appPerfCase.getTestCase();
        testCase.setId(id);
        this.testCaseService.createTestCase(testCase);
        return id;
    }

    public void updateAppPerfCase(@NotNull @Valid AppPerfCase appPerfCase) {
        AppPerfCaseEntity appPerfCaseEntity = (AppPerfCaseEntity)BeanMapper.map((Object)appPerfCase, AppPerfCaseEntity.class);
        this.appPerfCaseDao.updateAppPerfCase(appPerfCaseEntity);
        this.testCaseService.updateTestCase(appPerfCase.getTestCase());
    }

    public void deleteAppPerfCase(@NotNull String id) {
        this.appPerfCaseDao.deleteAppPerfCase(id);
        this.testCaseService.deleteTestCase(id);
    }

    public AppPerfCase findOne(String id) {
        AppPerfCaseEntity appPerfCaseEntity = this.appPerfCaseDao.findAppPerfCase(id);
        AppPerfCase appPerfCase = (AppPerfCase)BeanMapper.map((Object)appPerfCaseEntity, AppPerfCase.class);
        return appPerfCase;
    }

    public List<AppPerfCase> findList(List<String> idList) {
        List<AppPerfCaseEntity> appPerfCaseEntityList = this.appPerfCaseDao.findAppPerfCaseList(idList);
        List appPerfCaseList = BeanMapper.mapList(appPerfCaseEntityList, AppPerfCase.class);
        return appPerfCaseList;
    }

    public AppPerfCase findAppPerfCase(@NotNull String id) {
        AppPerfCase appPerfCase = this.findOne(id);
        this.joinTemplate.joinQuery((Object)appPerfCase);
        TestCase testCase = appPerfCase.getTestCase();
        if (testCase.getCategory() != null) {
            Category category = this.categoryService.findCategory(testCase.getCategory().getId());
            appPerfCase.getTestCase().setCategory(category);
        }
        if (testCase.getUpdateUser() != null) {
            User updateUser = this.userService.findUser(testCase.getUpdateUser().getId());
            appPerfCase.getTestCase().setUpdateUser(updateUser);
        }
        return appPerfCase;
    }

    public List<AppPerfCase> findAllAppPerfCase() {
        List<AppPerfCaseEntity> appPerfCaseEntityList = this.appPerfCaseDao.findAllAppPerfCase();
        List appPerfCaseList = BeanMapper.mapList(appPerfCaseEntityList, AppPerfCase.class);
        this.joinTemplate.joinQuery(appPerfCaseList);
        return appPerfCaseList;
    }

    public List<AppPerfCase> findAppPerfCaseList(AppPerfCaseQuery appPerfCaseQuery) {
        List<AppPerfCaseEntity> appPerfCaseEntityList = this.appPerfCaseDao.findAppPerfCaseList(appPerfCaseQuery);
        List appPerfCaseList = BeanMapper.mapList(appPerfCaseEntityList, AppPerfCase.class);
        this.joinTemplate.joinQuery(appPerfCaseList);
        return appPerfCaseList;
    }

    public Pagination<AppPerfCase> findAppPerfCasePage(AppPerfCaseQuery appPerfCaseQuery) {
        Pagination<AppPerfCaseEntity> pagination = this.appPerfCaseDao.findAppPerfCasePage(appPerfCaseQuery);
        List appPerfCaseList = BeanMapper.mapList((List)pagination.getDataList(), AppPerfCase.class);
        this.joinTemplate.joinQuery(appPerfCaseList);
        return PaginationBuilder.build(pagination, (List)appPerfCaseList);
    }

    public List<AppPerfCase> findAppPerfCaseListByTestCase(TestCaseQuery testCaseQuery) {
        List testCaseList = this.testCaseService.findTestCaseList(testCaseQuery);
        ArrayList<AppPerfCase> appPerfCaseList = new ArrayList<AppPerfCase>();
        if (CollectionUtils.isNotEmpty((Collection)testCaseList)) {
            for (TestCase testCase : testCaseList) {
                AppPerfCase appPerfCase = this.findAppPerfCase(testCase.getId());
                if (ObjectUtils.isEmpty((Object)appPerfCase)) continue;
                appPerfCaseList.add(appPerfCase);
            }
        }
        return appPerfCaseList;
    }
}

