/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.instance.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.apix.http.unit.instance.dao.RequestInstanceDao;
import io.tiklab.teston.test.apix.http.unit.instance.entity.RequestInstanceEntity;
import io.tiklab.teston.test.apix.http.unit.instance.model.RequestInstance;
import io.tiklab.teston.test.apix.http.unit.instance.model.RequestInstanceQuery;
import io.tiklab.teston.test.apix.http.unit.instance.service.RequestInstanceService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RequestInstanceServiceImpl
implements RequestInstanceService {
    @Autowired
    RequestInstanceDao requestInstanceDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createRequestInstance(@NotNull @Valid RequestInstance requestInstance) {
        RequestInstanceEntity requestInstanceEntity = (RequestInstanceEntity)BeanMapper.map((Object)requestInstance, RequestInstanceEntity.class);
        return this.requestInstanceDao.createRequestInstance(requestInstanceEntity);
    }

    public void updateRequestInstance(@NotNull @Valid RequestInstance requestInstance) {
        RequestInstanceEntity requestInstanceEntity = (RequestInstanceEntity)BeanMapper.map((Object)requestInstance, RequestInstanceEntity.class);
        this.requestInstanceDao.updateRequestInstance(requestInstanceEntity);
    }

    public void deleteRequestInstance(@NotNull String id) {
        this.requestInstanceDao.deleteRequestInstance(id);
    }

    public RequestInstance findOne(String id) {
        RequestInstanceEntity requestInstanceEntity = this.requestInstanceDao.findRequestInstance(id);
        RequestInstance requestInstance = (RequestInstance)BeanMapper.map((Object)requestInstanceEntity, RequestInstance.class);
        return requestInstance;
    }

    public List<RequestInstance> findList(List<String> idList) {
        List<RequestInstanceEntity> requestInstanceEntityList = this.requestInstanceDao.findRequestInstanceList(idList);
        List requestInstanceList = BeanMapper.mapList(requestInstanceEntityList, RequestInstance.class);
        return requestInstanceList;
    }

    public RequestInstance findRequestInstance(@NotNull String id) {
        RequestInstance requestInstance = this.findOne(id);
        this.joinTemplate.joinQuery((Object)requestInstance);
        return requestInstance;
    }

    public List<RequestInstance> findAllRequestInstance() {
        List<RequestInstanceEntity> requestInstanceEntityList = this.requestInstanceDao.findAllRequestInstance();
        List requestInstanceList = BeanMapper.mapList(requestInstanceEntityList, RequestInstance.class);
        this.joinTemplate.joinQuery(requestInstanceList);
        return requestInstanceList;
    }

    public List<RequestInstance> findRequestInstanceList(RequestInstanceQuery requestInstanceQuery) {
        List<RequestInstanceEntity> requestInstanceEntityList = this.requestInstanceDao.findRequestInstanceList(requestInstanceQuery);
        List requestInstanceList = BeanMapper.mapList(requestInstanceEntityList, RequestInstance.class);
        this.joinTemplate.joinQuery(requestInstanceList);
        return requestInstanceList;
    }

    public Pagination<RequestInstance> findRequestInstancePage(RequestInstanceQuery requestInstanceQuery) {
        Pagination<RequestInstanceEntity> pagination = this.requestInstanceDao.findRequestInstancePage(requestInstanceQuery);
        List requestInstanceList = BeanMapper.mapList((List)pagination.getDataList(), RequestInstance.class);
        this.joinTemplate.joinQuery(requestInstanceList);
        return PaginationBuilder.build(pagination, (List)requestInstanceList);
    }
}

