/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.instance.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.dal.jpa.criterial.condition.DeleteCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.DeleteBuilders;
import io.tiklab.eam.common.context.LoginContext;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.apix.http.unit.instance.dao.ApiUnitInstanceDao;
import io.tiklab.teston.test.apix.http.unit.instance.entity.ApiUnitInstanceEntity;
import io.tiklab.teston.test.apix.http.unit.instance.model.ApiUnitInstance;
import io.tiklab.teston.test.apix.http.unit.instance.model.ApiUnitInstanceQuery;
import io.tiklab.teston.test.apix.http.unit.instance.model.RequestInstance;
import io.tiklab.teston.test.apix.http.unit.instance.model.ResponseInstance;
import io.tiklab.teston.test.apix.http.unit.instance.service.ApiUnitInstanceService;
import io.tiklab.teston.test.apix.http.unit.instance.service.AssertInstanceService;
import io.tiklab.teston.test.apix.http.unit.instance.service.RequestInstanceService;
import io.tiklab.teston.test.apix.http.unit.instance.service.ResponseInstanceService;
import java.sql.Timestamp;
import java.util.Comparator;
import java.util.List;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiUnitInstanceServiceImpl
implements ApiUnitInstanceService {
    @Autowired
    ApiUnitInstanceDao apiUnitInstanceDao;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    RequestInstanceService requestInstanceService;
    @Autowired
    ResponseInstanceService responseInstanceService;
    @Autowired
    AssertInstanceService assertInstanceService;

    public String createApiUnitInstance(@NotNull @Valid ApiUnitInstance apiUnitInstance) {
        ApiUnitInstanceEntity apiUnitInstanceEntity = (ApiUnitInstanceEntity)BeanMapper.map((Object)apiUnitInstance, ApiUnitInstanceEntity.class);
        if (apiUnitInstance.getId() == null) {
            String uid = UUID.randomUUID().toString();
            String id = uid.trim().replaceAll("-", "");
            apiUnitInstanceEntity.setId(id);
        }
        apiUnitInstanceEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        String userId = LoginContext.getLoginId();
        apiUnitInstanceEntity.setCreateUser(userId);
        return this.apiUnitInstanceDao.createApiUnitInstance(apiUnitInstanceEntity);
    }

    public String createApiUnitInstanceWithNest(@NotNull @Valid List<ApiUnitInstance> apiUnitInstances) {
        String id = null;
        for (ApiUnitInstance apiUnitInstance : apiUnitInstances) {
            id = this.createApiUnitInstance(apiUnitInstance);
        }
        return id;
    }

    public void updateApiUnitInstance(@NotNull @Valid ApiUnitInstance apiUnitInstance) {
        ApiUnitInstanceEntity apiUnitInstanceEntity = (ApiUnitInstanceEntity)BeanMapper.map((Object)apiUnitInstance, ApiUnitInstanceEntity.class);
        this.apiUnitInstanceDao.updateApiUnitInstance(apiUnitInstanceEntity);
    }

    public void deleteApiUnitInstance(@NotNull String id) {
        this.requestInstanceService.deleteRequestInstance(id);
        this.responseInstanceService.deleteResponseInstance(id);
        this.assertInstanceService.deleteAssertInstance(id);
        this.apiUnitInstanceDao.deleteApiUnitInstance(id);
    }

    public void deleteApiUnitInstanceByApiUnitId(String apiUnitId) {
        DeleteCondition deleteCondition = DeleteBuilders.createDelete(ApiUnitInstanceEntity.class).eq("apiUnitId", (Object)apiUnitId).get();
        this.apiUnitInstanceDao.deleteApiUnitInstance(deleteCondition);
    }

    public ApiUnitInstance findOne(String id) {
        ApiUnitInstanceEntity apiUnitInstanceEntity = this.apiUnitInstanceDao.findApiUnitInstance(id);
        ApiUnitInstance apiUnitInstance = (ApiUnitInstance)BeanMapper.map((Object)apiUnitInstanceEntity, ApiUnitInstance.class);
        return apiUnitInstance;
    }

    public List<ApiUnitInstance> findList(List<String> idList) {
        List<ApiUnitInstanceEntity> apiUnitInstanceList = this.apiUnitInstanceDao.findApiUnitInstanceList(idList);
        List apiUnitInstances = BeanMapper.mapList(apiUnitInstanceList, ApiUnitInstance.class);
        return apiUnitInstances;
    }

    public ApiUnitInstance findApiUnitInstance(@NotNull String id) {
        ApiUnitInstance apiUnitInstance = this.findOne(id);
        this.joinTemplate.joinQuery((Object)apiUnitInstance);
        return apiUnitInstance;
    }

    public ApiUnitInstance findApiUnitInstanceWithNest(String id) {
        ResponseInstance responseInstance;
        ApiUnitInstance apiUnitInstance = this.findApiUnitInstance(id);
        RequestInstance requestInstance = this.requestInstanceService.findRequestInstance(id);
        if (requestInstance != null) {
            apiUnitInstance.setRequestInstance(requestInstance);
        }
        if ((responseInstance = this.responseInstanceService.findResponseInstance(id)) != null) {
            apiUnitInstance.setResponseInstance(responseInstance);
        }
        return apiUnitInstance;
    }

    public List<ApiUnitInstance> findAllApiUnitInstance() {
        List<ApiUnitInstanceEntity> apiUnitInstanceEntities = this.apiUnitInstanceDao.findAllApiUnitInstance();
        List apiUnitInstances = BeanMapper.mapList(apiUnitInstanceEntities, ApiUnitInstance.class);
        this.joinTemplate.joinQuery(apiUnitInstances);
        return apiUnitInstances;
    }

    public List<ApiUnitInstance> findApiUnitInstanceList(ApiUnitInstanceQuery apiUnitInstanceQuery) {
        List<ApiUnitInstanceEntity> apiUnitInstanceEntities = this.apiUnitInstanceDao.findApiUnitInstanceList(apiUnitInstanceQuery);
        List httpInstanceList = BeanMapper.mapList(apiUnitInstanceEntities, ApiUnitInstance.class);
        httpInstanceList.sort(Comparator.comparing(ApiUnitInstance::getCreateTime, Comparator.reverseOrder()));
        this.joinTemplate.joinQuery(httpInstanceList);
        List<ApiUnitInstance> httpInstances = httpInstanceList.stream().map(httpInstance -> {
            RequestInstance requestInstance = this.requestInstanceService.findRequestInstance(httpInstance.getId());
            httpInstance.setRequestInstance(requestInstance);
            return httpInstance;
        }).collect(Collectors.toList());
        return httpInstances;
    }

    public Pagination<ApiUnitInstance> findApiUnitInstancePage(ApiUnitInstanceQuery apiUnitInstanceQuery) {
        Pagination<ApiUnitInstanceEntity> pagination = this.apiUnitInstanceDao.findApiUnitInstancePage(apiUnitInstanceQuery);
        List httpInstanceList = BeanMapper.mapList((List)pagination.getDataList(), ApiUnitInstance.class);
        httpInstanceList.sort(Comparator.comparing(ApiUnitInstance::getCreateTime, Comparator.reverseOrder()));
        this.joinTemplate.joinQuery(httpInstanceList);
        List httpInstances = httpInstanceList.stream().map(httpInstance -> {
            RequestInstance requestInstance = this.requestInstanceService.findRequestInstance(httpInstance.getId());
            httpInstance.setRequestInstance(requestInstance);
            return httpInstance;
        }).collect(Collectors.toList());
        return PaginationBuilder.build(pagination, httpInstances);
    }

    public String saveApiUnitInstanceToSql(ApiUnitInstance apiUnitInstance) {
        ResponseInstance responseInstance;
        String apiUnitInstanceId = this.createApiUnitInstance(apiUnitInstance);
        apiUnitInstance.setId(apiUnitInstanceId);
        RequestInstance requestInstance = apiUnitInstance.getRequestInstance();
        if (requestInstance != null) {
            requestInstance.setId(apiUnitInstanceId);
            requestInstance.setApiUnitInstance(new ApiUnitInstance().setId(apiUnitInstanceId));
            this.requestInstanceService.createRequestInstance(requestInstance);
        }
        if ((responseInstance = apiUnitInstance.getResponseInstance()) != null) {
            responseInstance.setId(apiUnitInstanceId);
            responseInstance.setApiUnitInstance(new ApiUnitInstance().setId(apiUnitInstanceId));
            this.responseInstanceService.createResponseInstance(responseInstance);
        }
        return apiUnitInstanceId;
    }
}

