/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.instance.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.test.apix.http.unit.instance.model.RequestInstance;
import io.tiklab.teston.test.apix.http.unit.instance.model.RequestInstanceQuery;
import io.tiklab.teston.test.apix.http.unit.instance.service.RequestInstanceService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/requestInstance"})
@Api(name="RequestInstanceController", desc="\u6d4b\u8bd5\u5b9e\u4f8b\u2014\u2014\u8bf7\u6c42\u7ba1\u7406")
public class RequestInstanceController {
    private static Logger logger = LoggerFactory.getLogger(RequestInstanceController.class);
    @Autowired
    private RequestInstanceService requestInstanceService;

    @RequestMapping(path={"/createRequestInstance"}, method={RequestMethod.POST})
    @ApiMethod(name="createRequestInstance", desc="\u521b\u5efa\u8bf7\u6c42\u6570\u636e\u5b9e\u4f8b")
    @ApiParam(name="requestInstance", desc="requestInstance", required=true)
    public Result<String> createRequestInstance(@RequestBody @NotNull @Valid RequestInstance requestInstance) {
        String id = this.requestInstanceService.createRequestInstance(requestInstance);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateRequestInstance"}, method={RequestMethod.POST})
    @ApiMethod(name="updateRequestInstance", desc="\u66f4\u65b0\u8bf7\u6c42\u6570\u636e\u5b9e\u4f8b")
    @ApiParam(name="requestInstance", desc="requestInstance", required=true)
    public Result<Void> updateRequestInstance(@RequestBody @NotNull @Valid RequestInstance requestInstance) {
        this.requestInstanceService.updateRequestInstance(requestInstance);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteRequestInstance"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteRequestInstance", desc="\u5220\u9664\u8bf7\u6c42\u6570\u636e\u5b9e\u4f8b")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteRequestInstance(@NotNull String id) {
        this.requestInstanceService.deleteRequestInstance(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findRequestInstance"}, method={RequestMethod.POST})
    @ApiMethod(name="findRequestInstance", desc="\u67e5\u627e\u8bf7\u6c42\u6570\u636e\u5b9e\u4f8b")
    @ApiParam(name="id", desc="id", required=true)
    public Result<RequestInstance> findRequestInstance(@NotNull String id) {
        RequestInstance requestInstance = this.requestInstanceService.findRequestInstance(id);
        return Result.ok((Object)requestInstance);
    }

    @RequestMapping(path={"/findAllRequestInstance"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllRequestInstance", desc="\u67e5\u627e\u6240\u6709\u8bf7\u6c42\u6570\u636e\u5b9e\u4f8b")
    public Result<List<RequestInstance>> findAllRequestInstance() {
        List requestInstanceList = this.requestInstanceService.findAllRequestInstance();
        return Result.ok((Object)requestInstanceList);
    }

    @RequestMapping(path={"/findRequestInstanceList"}, method={RequestMethod.POST})
    @ApiMethod(name="findRequestInstanceList", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u67e5\u8be2\u8bf7\u6c42\u6570\u636e\u5b9e\u4f8b\u5217\u8868")
    @ApiParam(name="requestInstanceQuery", desc="requestInstanceQuery", required=true)
    public Result<List<RequestInstance>> findRequestInstanceList(@RequestBody @Valid @NotNull RequestInstanceQuery requestInstanceQuery) {
        List requestInstanceList = this.requestInstanceService.findRequestInstanceList(requestInstanceQuery);
        return Result.ok((Object)requestInstanceList);
    }

    @RequestMapping(path={"/findRequestInstancePage"}, method={RequestMethod.POST})
    @ApiMethod(name="findRequestInstancePage", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u6309\u5206\u9875\u67e5\u8be2\u8bf7\u6c42\u6570\u636e\u5b9e\u4f8b")
    @ApiParam(name="requestInstanceQuery", desc="requestInstanceQuery", required=true)
    public Result<Pagination<RequestInstance>> findRequestInstancePage(@RequestBody @Valid @NotNull RequestInstanceQuery requestInstanceQuery) {
        Pagination pagination = this.requestInstanceService.findRequestInstancePage(requestInstanceQuery);
        return Result.ok((Object)pagination);
    }
}

