/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.execute.service;

import io.tiklab.core.exception.ApplicationException;
import io.tiklab.rpc.client.router.lookup.FixedLookup;
import io.tiklab.rpc.client.router.lookup.Lookup;
import io.tiklab.teston.agent.api.http.unit.ApiUnitTestService;
import io.tiklab.teston.support.agentconfig.model.AgentConfig;
import io.tiklab.teston.support.agentconfig.model.AgentConfigQuery;
import io.tiklab.teston.support.agentconfig.service.AgentConfigService;
import io.tiklab.teston.support.utils.RpcClientApixUtil;
import io.tiklab.teston.test.apix.http.unit.cases.model.ApiUnitCase;
import io.tiklab.teston.test.apix.http.unit.cases.model.ApiUnitCaseDataConstruction;
import io.tiklab.teston.test.apix.http.unit.cases.service.ApiUnitCaseService;
import io.tiklab.teston.test.apix.http.unit.cases.service.AssertService;
import io.tiklab.teston.test.apix.http.unit.execute.model.ApiUnitTestRequest;
import io.tiklab.teston.test.apix.http.unit.execute.service.ApiUnitExecuteDispatchService;
import io.tiklab.teston.test.apix.http.unit.instance.model.ApiUnitInstance;
import io.tiklab.teston.test.apix.http.unit.instance.model.ApiUnitInstanceBind;
import io.tiklab.teston.test.apix.http.unit.instance.model.ApiUnitInstanceBindQuery;
import io.tiklab.teston.test.apix.http.unit.instance.service.ApiUnitInstanceBindService;
import io.tiklab.teston.test.apix.http.unit.instance.service.ApiUnitInstanceService;
import io.tiklab.teston.test.apix.http.unit.instance.service.AssertInstanceService;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ApiUnitExecuteDispatchServiceImpl
implements ApiUnitExecuteDispatchService {
    @Autowired
    ApiUnitCaseService apiUnitCaseService;
    @Autowired
    ApiUnitInstanceService apiUnitInstanceService;
    @Autowired
    AssertService assertService;
    @Autowired
    AssertInstanceService assertInstanceService;
    @Autowired
    ApiUnitInstanceBindService apiUnitInstanceBindService;
    @Autowired
    AgentConfigService agentConfigService;
    @Autowired
    RpcClientApixUtil rpcClientApixUtil;
    @Autowired
    ApiUnitTestService apiUnitTestService;
    @Value(value="${teston-agent.embbed.enable:false}")
    Boolean enable;

    ApiUnitTestService apiUnitTestServiceRpc(String agentUrl) {
        return (ApiUnitTestService)this.rpcClientApixUtil.rpcClient().getBean(ApiUnitTestService.class, (Lookup)new FixedLookup(agentUrl));
    }

    public ApiUnitInstance execute(ApiUnitTestRequest apiUnitTestRequest) {
        Object preUrl;
        Map<String, Object> afterScript;
        String apiUnitId = apiUnitTestRequest.getApiUnitCase().getId();
        ApiUnitCase apiUnitCase = this.apiUnitCaseService.findApiUnitCase(apiUnitId);
        ApiUnitCaseDataConstruction apiUnitCaseDataConstruction = this.apiUnitCaseService.findApiUnitCaseExt(apiUnitCase);
        apiUnitTestRequest.setApiUnitCase(apiUnitCase);
        apiUnitTestRequest.setApiUnitCaseExt(apiUnitCaseDataConstruction);
        ApiUnitInstance apiUnitInstance = null;
        try {
            if (this.enable.booleanValue()) {
                apiUnitInstance = this.apiUnitTestService.execute(apiUnitTestRequest);
            } else {
                List agentConfigList = this.agentConfigService.findAgentConfigList(new AgentConfigQuery());
                if (CollectionUtils.isNotEmpty((Collection)agentConfigList)) {
                    AgentConfig agentConfig = (AgentConfig)agentConfigList.get(0);
                    apiUnitInstance = this.apiUnitTestServiceRpc(agentConfig.getUrl()).execute(apiUnitTestRequest);
                }
            }
        }
        catch (Exception e) {
            throw new ApplicationException("agent\u9519\u8bef");
        }
        if (apiUnitTestRequest.getApiUnitCaseExt().getAfterScript() != null && (afterScript = this.actionAfterScript(apiUnitTestRequest.getApiUnitCaseExt().getAfterScript())) != null && afterScript.get("preUrl") != null && ((Boolean)(preUrl = afterScript.get("preUrl"))).booleanValue()) {
            apiUnitInstance.setAfterScript(apiUnitTestRequest.getApiEnv());
        }
        if (apiUnitTestRequest.getExeType() == null) {
            this.saveInstance(apiUnitInstance, apiUnitId);
        }
        return apiUnitInstance;
    }

    private void saveInstance(ApiUnitInstance apiUnitInstance, String apiUnitId) {
        ApiUnitInstanceBindQuery apiUnitInstanceBindQuery = new ApiUnitInstanceBindQuery();
        apiUnitInstanceBindQuery.setApiUnitId(apiUnitId);
        List apiUnitInstanceBindList = this.apiUnitInstanceBindService.findApiUnitInstanceBindList(apiUnitInstanceBindQuery);
        if (apiUnitInstanceBindList != null && apiUnitInstanceBindList.size() > 0) {
            String instanceId = ((ApiUnitInstanceBind)apiUnitInstanceBindList.get(0)).getId();
            ApiUnitInstance preApiUnitInstance = this.apiUnitInstanceService.findApiUnitInstance(instanceId);
            Integer executeNumber = preApiUnitInstance.getExecuteNumber();
            executeNumber = executeNumber + 1;
            apiUnitInstance.setExecuteNumber(executeNumber);
        } else {
            apiUnitInstance.setExecuteNumber(Integer.valueOf(1));
        }
        String apiUnitInstanceId = this.apiUnitInstanceService.saveApiUnitInstanceToSql(apiUnitInstance);
        ApiUnitInstanceBind apiUnitInstanceBind = new ApiUnitInstanceBind();
        apiUnitInstanceBind.setId(apiUnitInstanceId);
        apiUnitInstanceBind.setApiUnitInstance(new ApiUnitInstance().setId(apiUnitInstanceId));
        apiUnitInstanceBind.setApiUnitId(apiUnitId);
        this.apiUnitInstanceBindService.createApiUnitInstanceBind(apiUnitInstanceBind);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> actionAfterScript(String script) {
        if (script != null) {
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName("JavaScript");
            URL resourceUrl = this.getClass().getClassLoader().getResource("static/script.js");
            String path = resourceUrl.getPath();
            try (FileInputStream fip = new FileInputStream(path);){
                Map map;
                try (InputStreamReader reader = new InputStreamReader((InputStream)fip, StandardCharsets.UTF_8);){
                    Map resultMap;
                    engine.eval(reader);
                    engine.put("to", engine.get("to"));
                    engine.eval(script);
                    Invocable invocable = (Invocable)((Object)engine);
                    Object result = invocable.invokeMethod(engine.get("to"), "getPreUrl", new Object[0]);
                    Bindings bindings = engine.createBindings();
                    bindings.put("result", result);
                    map = resultMap = (Map)engine.eval("JSON.parse(JSON.stringify(result))", bindings);
                }
                return map;
            }
            catch (Exception e) {
                throw new ApplicationException((Throwable)e);
            }
        }
        return null;
    }
}

