/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.apix.http.unit.cases.dao.RequestHeaderDao;
import io.tiklab.teston.test.apix.http.unit.cases.entity.RequestHeaderEntity;
import io.tiklab.teston.test.apix.http.unit.cases.model.ApiUnitCase;
import io.tiklab.teston.test.apix.http.unit.cases.model.RequestHeader;
import io.tiklab.teston.test.apix.http.unit.cases.model.RequestHeaderQuery;
import io.tiklab.teston.test.apix.http.unit.cases.service.RequestHeaderService;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RequestHeaderServiceImpl
implements RequestHeaderService {
    @Autowired
    RequestHeaderDao requestHeaderDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createRequestHeader(@NotNull @Valid RequestHeader requestHeader) {
        RequestHeaderEntity requestHeaderEntity = (RequestHeaderEntity)BeanMapper.map((Object)requestHeader, RequestHeaderEntity.class);
        return this.requestHeaderDao.createRequestHeader(requestHeaderEntity);
    }

    public void updateRequestHeader(@NotNull @Valid RequestHeader requestHeader) {
        RequestHeaderEntity requestHeaderEntity = (RequestHeaderEntity)BeanMapper.map((Object)requestHeader, RequestHeaderEntity.class);
        this.requestHeaderDao.updateRequestHeader(requestHeaderEntity);
    }

    public void deleteRequestHeader(@NotNull String id) {
        this.requestHeaderDao.deleteRequestHeader(id);
    }

    public RequestHeader findOne(String id) {
        RequestHeaderEntity requestHeaderEntity = this.requestHeaderDao.findRequestHeader(id);
        RequestHeader requestHeader = (RequestHeader)BeanMapper.map((Object)requestHeaderEntity, RequestHeader.class);
        return requestHeader;
    }

    public List<RequestHeader> findList(List<String> idList) {
        List<RequestHeaderEntity> requestHeaderEntityList = this.requestHeaderDao.findRequestHeaderList(idList);
        List requestHeaderList = BeanMapper.mapList(requestHeaderEntityList, RequestHeader.class);
        return requestHeaderList;
    }

    public RequestHeader findRequestHeader(@NotNull String id) {
        RequestHeader requestHeader = this.findOne(id);
        this.joinTemplate.joinQuery((Object)requestHeader);
        return requestHeader;
    }

    public List<RequestHeader> findAllRequestHeader() {
        List<RequestHeaderEntity> requestHeaderEntityList = this.requestHeaderDao.findAllRequestHeader();
        List requestHeaderList = BeanMapper.mapList(requestHeaderEntityList, RequestHeader.class);
        this.joinTemplate.joinQuery(requestHeaderList);
        return requestHeaderList;
    }

    public List<RequestHeader> findRequestHeaderList(RequestHeaderQuery requestHeaderQuery) {
        List<RequestHeaderEntity> requestHeaderEntityList = this.requestHeaderDao.findRequestHeaderList(requestHeaderQuery);
        List requestHeaderList = BeanMapper.mapList(requestHeaderEntityList, RequestHeader.class);
        this.joinTemplate.joinQuery(requestHeaderList);
        return requestHeaderList;
    }

    public Pagination<RequestHeader> findRequestHeaderPage(RequestHeaderQuery requestHeaderQuery) {
        Pagination<RequestHeaderEntity> pagination = this.requestHeaderDao.findRequestHeaderPage(requestHeaderQuery);
        List requestHeaderList = BeanMapper.mapList((List)pagination.getDataList(), RequestHeader.class);
        this.joinTemplate.joinQuery(requestHeaderList);
        return PaginationBuilder.build(pagination, (List)requestHeaderList);
    }

    public Map<String, String> jointHeader(ApiUnitCase apiUnitCase) {
        HashMap<String, String> headerMap = new HashMap<String, String>();
        RequestHeaderQuery requestHeaderQuery = new RequestHeaderQuery();
        requestHeaderQuery.setApiUnitId(apiUnitCase.getId());
        List<RequestHeader> requestHeaderList = this.findRequestHeaderList(requestHeaderQuery);
        if (CollectionUtils.isNotEmpty(requestHeaderList)) {
            for (RequestHeader requestHeader : requestHeaderList) {
                String headerName = requestHeader.getHeaderName();
                String value = requestHeader.getValue();
                headerMap.put(headerName, value);
            }
        }
        return headerMap;
    }
}

