/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.apix.http.unit.cases.dao.RequestBodyDao;
import io.tiklab.teston.test.apix.http.unit.cases.entity.RequestBodyEntity;
import io.tiklab.teston.test.apix.http.unit.cases.model.RequestBody;
import io.tiklab.teston.test.apix.http.unit.cases.model.RequestBodyQuery;
import io.tiklab.teston.test.apix.http.unit.cases.service.RequestBodyService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RequestBodyServiceImpl
implements RequestBodyService {
    @Autowired
    RequestBodyDao requestBodyDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createRequestBody(@NotNull @Valid RequestBody requestBody) {
        RequestBodyEntity requestBodyEntity = (RequestBodyEntity)BeanMapper.map((Object)requestBody, RequestBodyEntity.class);
        return this.requestBodyDao.createRequestBody(requestBodyEntity);
    }

    public void updateRequestBody(@NotNull @Valid RequestBody requestBody) {
        RequestBodyEntity requestBodyEntity = (RequestBodyEntity)BeanMapper.map((Object)requestBody, RequestBodyEntity.class);
        this.requestBodyDao.updateRequestBody(requestBodyEntity);
    }

    public void deleteRequestBody(@NotNull String id) {
        this.requestBodyDao.deleteRequestBody(id);
    }

    public RequestBody findOne(String id) {
        RequestBodyEntity requestBodyEntity = this.requestBodyDao.findRequestBody(id);
        RequestBody requestBody = (RequestBody)BeanMapper.map((Object)requestBodyEntity, RequestBody.class);
        return requestBody;
    }

    public List<RequestBody> findList(List<String> idList) {
        List<RequestBodyEntity> requestBodyEntityList = this.requestBodyDao.findRequestBodyList(idList);
        List requestBodyList = BeanMapper.mapList(requestBodyEntityList, RequestBody.class);
        return requestBodyList;
    }

    public RequestBody findRequestBody(@NotNull String id) {
        RequestBody requestBody = this.findOne(id);
        this.joinTemplate.joinQuery((Object)requestBody);
        return requestBody;
    }

    public List<RequestBody> findAllRequestBody() {
        List<RequestBodyEntity> requestBodyEntityList = this.requestBodyDao.findAllRequestBody();
        List requestBodyList = BeanMapper.mapList(requestBodyEntityList, RequestBody.class);
        this.joinTemplate.joinQuery(requestBodyList);
        return requestBodyList;
    }

    public List<RequestBody> findRequestBodyList(RequestBodyQuery requestBodyQuery) {
        List<RequestBodyEntity> requestBodyEntityList = this.requestBodyDao.findRequestBodyList(requestBodyQuery);
        List requestBodyList = BeanMapper.mapList(requestBodyEntityList, RequestBody.class);
        this.joinTemplate.joinQuery(requestBodyList);
        return requestBodyList;
    }

    public Pagination<RequestBody> findRequestBodyPage(RequestBodyQuery requestBodyQuery) {
        Pagination<RequestBodyEntity> pagination = this.requestBodyDao.findRequestBodyPage(requestBodyQuery);
        List requestBodyList = BeanMapper.mapList((List)pagination.getDataList(), RequestBody.class);
        this.joinTemplate.joinQuery(requestBodyList);
        return PaginationBuilder.build(pagination, (List)requestBodyList);
    }
}

