/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.apix.http.unit.cases.dao.RawResponseDao;
import io.tiklab.teston.test.apix.http.unit.cases.entity.RawResponseEntity;
import io.tiklab.teston.test.apix.http.unit.cases.model.RawResponse;
import io.tiklab.teston.test.apix.http.unit.cases.model.RawResponseQuery;
import io.tiklab.teston.test.apix.http.unit.cases.service.RawResponseService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class RawResponseServiceImpl
implements RawResponseService {
    @Autowired
    RawResponseDao rawResponseDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createRawResponse(@NotNull @Valid RawResponse rawResponse) {
        RawResponseEntity rawResponseEntity = (RawResponseEntity)BeanMapper.map((Object)rawResponse, RawResponseEntity.class);
        return this.rawResponseDao.createRawResponse(rawResponseEntity);
    }

    public void updateRawResponse(@NotNull @Valid RawResponse rawResponse) {
        RawResponseEntity rawResponseEntity = (RawResponseEntity)BeanMapper.map((Object)rawResponse, RawResponseEntity.class);
        this.rawResponseDao.updateRawResponse(rawResponseEntity);
    }

    public void deleteRawResponse(@NotNull String id) {
        this.rawResponseDao.deleteRawResponse(id);
    }

    public RawResponse findOne(String id) {
        RawResponseEntity rawResponseEntity = this.rawResponseDao.findRawResponse(id);
        RawResponse rawResponse = (RawResponse)BeanMapper.map((Object)rawResponseEntity, RawResponse.class);
        return rawResponse;
    }

    public List<RawResponse> findList(List<String> idList) {
        List<RawResponseEntity> rawResponseEntityList = this.rawResponseDao.findRawResponseList(idList);
        List rawResponseList = BeanMapper.mapList(rawResponseEntityList, RawResponse.class);
        return rawResponseList;
    }

    public RawResponse findRawResponse(@NotNull String id) {
        RawResponse rawResponse = this.findOne(id);
        this.joinTemplate.joinQuery((Object)rawResponse);
        return rawResponse;
    }

    public List<RawResponse> findAllRawResponse() {
        List<RawResponseEntity> rawResponseEntityList = this.rawResponseDao.findAllRawResponse();
        List rawResponseList = BeanMapper.mapList(rawResponseEntityList, RawResponse.class);
        this.joinTemplate.joinQuery(rawResponseList);
        return rawResponseList;
    }

    public List<RawResponse> findRawResponseList(RawResponseQuery rawResponseQuery) {
        List<RawResponseEntity> rawResponseEntityList = this.rawResponseDao.findRawResponseList(rawResponseQuery);
        List rawResponseList = BeanMapper.mapList(rawResponseEntityList, RawResponse.class);
        this.joinTemplate.joinQuery(rawResponseList);
        return rawResponseList;
    }

    public Pagination<RawResponse> findRawResponsePage(RawResponseQuery rawResponseQuery) {
        Pagination<RawResponseEntity> pagination = this.rawResponseDao.findRawResponsePage(rawResponseQuery);
        List rawResponseList = BeanMapper.mapList((List)pagination.getDataList(), RawResponse.class);
        this.joinTemplate.joinQuery(rawResponseList);
        return PaginationBuilder.build(pagination, (List)rawResponseList);
    }
}

