/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.apix.http.unit.cases.dao.QueryParamDao;
import io.tiklab.teston.test.apix.http.unit.cases.entity.QueryParamsEntity;
import io.tiklab.teston.test.apix.http.unit.cases.model.ApiUnitCase;
import io.tiklab.teston.test.apix.http.unit.cases.model.QueryParamQuery;
import io.tiklab.teston.test.apix.http.unit.cases.model.QueryParams;
import io.tiklab.teston.test.apix.http.unit.cases.service.QueryParamService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class QueryParamServiceImpl
implements QueryParamService {
    @Autowired
    QueryParamDao queryParamDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createQueryParam(@NotNull @Valid QueryParams queryParams) {
        QueryParamsEntity queryParamsEntity = (QueryParamsEntity)BeanMapper.map((Object)queryParams, QueryParamsEntity.class);
        return this.queryParamDao.createQueryParam(queryParamsEntity);
    }

    public void updateQueryParam(@NotNull @Valid QueryParams queryParams) {
        QueryParamsEntity queryParamsEntity = (QueryParamsEntity)BeanMapper.map((Object)queryParams, QueryParamsEntity.class);
        this.queryParamDao.updateQueryParam(queryParamsEntity);
    }

    public void deleteQueryParam(@NotNull String id) {
        this.queryParamDao.deleteQueryParam(id);
    }

    public QueryParams findOne(String id) {
        QueryParamsEntity queryParamsEntity = this.queryParamDao.findQueryParam(id);
        QueryParams queryParams = (QueryParams)BeanMapper.map((Object)queryParamsEntity, QueryParams.class);
        return queryParams;
    }

    public List<QueryParams> findList(List<String> idList) {
        List<QueryParamsEntity> queryParamsEntityList = this.queryParamDao.findQueryParamList(idList);
        List queryParamsList = BeanMapper.mapList(queryParamsEntityList, QueryParams.class);
        return queryParamsList;
    }

    public QueryParams findQueryParam(@NotNull String id) {
        QueryParams queryParams = this.findOne(id);
        this.joinTemplate.joinQuery((Object)queryParams);
        return queryParams;
    }

    public List<QueryParams> findAllQueryParam() {
        List<QueryParamsEntity> queryParamsEntityList = this.queryParamDao.findAllQueryParam();
        List queryParamsList = BeanMapper.mapList(queryParamsEntityList, QueryParams.class);
        this.joinTemplate.joinQuery(queryParamsList);
        return queryParamsList;
    }

    public List<QueryParams> findQueryParamList(QueryParamQuery queryParamQuery) {
        List<QueryParamsEntity> queryParamsEntityList = this.queryParamDao.findQueryParamList(queryParamQuery);
        List queryParamsList = BeanMapper.mapList(queryParamsEntityList, QueryParams.class);
        this.joinTemplate.joinQuery(queryParamsList);
        return queryParamsList;
    }

    public Pagination<QueryParams> findQueryParamPage(QueryParamQuery queryParamQuery) {
        Pagination<QueryParamsEntity> pagination = this.queryParamDao.findQueryParamPage(queryParamQuery);
        List queryParamsList = BeanMapper.mapList((List)pagination.getDataList(), QueryParams.class);
        this.joinTemplate.joinQuery(queryParamsList);
        return PaginationBuilder.build(pagination, (List)queryParamsList);
    }

    public String jointParam(ApiUnitCase apiUnitCase) {
        Object param = "";
        QueryParamQuery queryParamQuery = new QueryParamQuery();
        queryParamQuery.setApiUnitId(apiUnitCase.getId());
        List<QueryParams> queryParamsList = this.findQueryParamList(queryParamQuery);
        if (CollectionUtils.isNotEmpty(queryParamsList)) {
            for (QueryParams queryParams : queryParamsList) {
                param = (String)param + queryParams.getParamName() + "=" + queryParams.getValue() + "&";
            }
        }
        return param;
    }
}

