/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.apix.http.unit.cases.dao.PreScriptDao;
import io.tiklab.teston.test.apix.http.unit.cases.entity.PreScriptEntity;
import io.tiklab.teston.test.apix.http.unit.cases.model.PreScript;
import io.tiklab.teston.test.apix.http.unit.cases.model.PreScriptQuery;
import io.tiklab.teston.test.apix.http.unit.cases.service.PreScriptService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class PreScriptServiceImpl
implements PreScriptService {
    @Autowired
    PreScriptDao preScriptDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createPreScript(@NotNull @Valid PreScript preScript) {
        PreScriptEntity preScriptEntity = (PreScriptEntity)BeanMapper.map((Object)preScript, PreScriptEntity.class);
        return this.preScriptDao.createPreScript(preScriptEntity);
    }

    public void updatePreScript(@NotNull @Valid PreScript preScript) {
        PreScriptEntity preScriptEntity = (PreScriptEntity)BeanMapper.map((Object)preScript, PreScriptEntity.class);
        this.preScriptDao.updatePreScript(preScriptEntity);
    }

    public void deletePreScript(@NotNull String id) {
        this.preScriptDao.deletePreScript(id);
    }

    public PreScript findOne(String id) {
        PreScriptEntity preScriptEntity = this.preScriptDao.findPreScript(id);
        PreScript preScript = (PreScript)BeanMapper.map((Object)preScriptEntity, PreScript.class);
        return preScript;
    }

    public List<PreScript> findList(List<String> idList) {
        List<PreScriptEntity> preScriptEntityList = this.preScriptDao.findPreScriptList(idList);
        List preScriptList = BeanMapper.mapList(preScriptEntityList, PreScript.class);
        return preScriptList;
    }

    public PreScript findPreScript(@NotNull String id) {
        PreScript preScript = this.findOne(id);
        this.joinTemplate.joinQuery((Object)preScript);
        return preScript;
    }

    public List<PreScript> findAllPreScript() {
        List<PreScriptEntity> preScriptEntityList = this.preScriptDao.findAllPreScript();
        List preScriptList = BeanMapper.mapList(preScriptEntityList, PreScript.class);
        this.joinTemplate.joinQuery(preScriptList);
        return preScriptList;
    }

    public List<PreScript> findPreScriptList(PreScriptQuery preScriptQuery) {
        List<PreScriptEntity> preScriptEntityList = this.preScriptDao.findPreScriptList(preScriptQuery);
        List preScriptList = BeanMapper.mapList(preScriptEntityList, PreScript.class);
        this.joinTemplate.joinQuery(preScriptList);
        return preScriptList;
    }

    public Pagination<PreScript> findPreScriptPage(PreScriptQuery preScriptQuery) {
        Pagination<PreScriptEntity> pagination = this.preScriptDao.findPreScriptPage(preScriptQuery);
        List preScriptList = BeanMapper.mapList((List)pagination.getDataList(), PreScript.class);
        this.joinTemplate.joinQuery(preScriptList);
        return PaginationBuilder.build(pagination, (List)preScriptList);
    }
}

