/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.apix.http.unit.cases.dao.JsonResponseDao;
import io.tiklab.teston.test.apix.http.unit.cases.entity.JsonResponseEntity;
import io.tiklab.teston.test.apix.http.unit.cases.model.JsonResponse;
import io.tiklab.teston.test.apix.http.unit.cases.model.JsonResponseQuery;
import io.tiklab.teston.test.apix.http.unit.cases.service.JsonResponseService;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JsonResponseServiceImpl
implements JsonResponseService {
    @Autowired
    JsonResponseDao jsonResponseDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createJsonResponse(@NotNull @Valid JsonResponse jsonResponse) {
        JsonResponseEntity jsonResponseEntity = (JsonResponseEntity)BeanMapper.map((Object)jsonResponse, JsonResponseEntity.class);
        return this.jsonResponseDao.createJsonResponse(jsonResponseEntity);
    }

    public void updateJsonResponse(@NotNull @Valid JsonResponse jsonResponse) {
        JsonResponseEntity jsonResponseEntity = (JsonResponseEntity)BeanMapper.map((Object)jsonResponse, JsonResponseEntity.class);
        this.jsonResponseDao.updateJsonResponse(jsonResponseEntity);
    }

    public void deleteJsonResponse(@NotNull String id) {
        this.jsonResponseDao.deleteJsonResponse(id);
    }

    public JsonResponse findOne(String id) {
        JsonResponseEntity jsonResponseEntity = this.jsonResponseDao.findJsonResponse(id);
        JsonResponse jsonResponse = (JsonResponse)BeanMapper.map((Object)jsonResponseEntity, JsonResponse.class);
        return jsonResponse;
    }

    public List<JsonResponse> findList(List<String> idList) {
        List<JsonResponseEntity> jsonResponseEntityList = this.jsonResponseDao.findJsonResponseList(idList);
        List jsonResponseList = BeanMapper.mapList(jsonResponseEntityList, JsonResponse.class);
        return jsonResponseList;
    }

    public JsonResponse findJsonResponse(@NotNull String id) {
        JsonResponse jsonResponse = this.findOne(id);
        this.joinTemplate.joinQuery((Object)jsonResponse);
        return jsonResponse;
    }

    public List<JsonResponse> findAllJsonResponse() {
        List<JsonResponseEntity> jsonResponseEntityList = this.jsonResponseDao.findAllJsonResponse();
        List jsonResponseList = BeanMapper.mapList(jsonResponseEntityList, JsonResponse.class);
        this.joinTemplate.joinQuery(jsonResponseList);
        return jsonResponseList;
    }

    public List<JsonResponse> findJsonResponseList(JsonResponseQuery jsonResponseQuery) {
        List<JsonResponseEntity> jsonResponseEntityList = this.jsonResponseDao.findJsonResponseList(jsonResponseQuery);
        List jsonResponseList = BeanMapper.mapList(jsonResponseEntityList, JsonResponse.class);
        this.joinTemplate.joinQuery(jsonResponseList);
        return jsonResponseList;
    }

    public Pagination<JsonResponse> findJsonResponsePage(JsonResponseQuery jsonResponseQuery) {
        Pagination<JsonResponseEntity> pagination = this.jsonResponseDao.findJsonResponsePage(jsonResponseQuery);
        List jsonResponseList = BeanMapper.mapList((List)pagination.getDataList(), JsonResponse.class);
        this.joinTemplate.joinQuery(jsonResponseList);
        return PaginationBuilder.build(pagination, (List)jsonResponseList);
    }

    public List<JsonResponse> findJsonResponseListTree(JsonResponseQuery jsonResponseQuery) {
        List<JsonResponse> matchJsonResponseList = this.findJsonResponseList(jsonResponseQuery);
        List<JsonResponse> topJsonResponseList = this.findTopJsonResponseList(matchJsonResponseList);
        if (topJsonResponseList != null && topJsonResponseList.size() > 0) {
            for (JsonResponse jsonResponse : topJsonResponseList) {
                this.setChildren(matchJsonResponseList, jsonResponse);
            }
        }
        return topJsonResponseList;
    }

    List<JsonResponse> findTopJsonResponseList(List<JsonResponse> matchJsonResponseList) {
        List<JsonResponse> jsonResponseList = matchJsonResponseList.stream().filter(jsonResponse -> jsonResponse.getParent() == null || jsonResponse.getParent().getId() == null).collect(Collectors.toList());
        return jsonResponseList;
    }

    void setChildren(List<JsonResponse> matchJsonResponseList, JsonResponse parentJsonResponse) {
        List childList = matchJsonResponseList.stream().filter(jsonResponse -> jsonResponse.getParent() != null && jsonResponse.getParent().getId() != null && jsonResponse.getParent().getId().equals(parentJsonResponse.getId())).collect(Collectors.toList());
        if (childList != null && childList.size() > 0) {
            parentJsonResponse.setChildren(childList);
            for (JsonResponse jsonResponse2 : childList) {
                this.setChildren(matchJsonResponseList, jsonResponse2);
            }
        }
    }
}

