/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.apix.http.unit.cases.dao.JsonParamDao;
import io.tiklab.teston.test.apix.http.unit.cases.entity.JsonParamEntity;
import io.tiklab.teston.test.apix.http.unit.cases.model.JsonParam;
import io.tiklab.teston.test.apix.http.unit.cases.model.JsonParamQuery;
import io.tiklab.teston.test.apix.http.unit.cases.service.JsonParamService;
import java.util.List;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class JsonParamServiceImpl
implements JsonParamService {
    @Autowired
    JsonParamDao jsonParamDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createJsonParam(@NotNull @Valid JsonParam jsonParam) {
        JsonParamEntity jsonParamEntity = (JsonParamEntity)BeanMapper.map((Object)jsonParam, JsonParamEntity.class);
        return this.jsonParamDao.createJsonParam(jsonParamEntity);
    }

    public void updateJsonParam(@NotNull @Valid JsonParam jsonParam) {
        JsonParamEntity jsonParamEntity = (JsonParamEntity)BeanMapper.map((Object)jsonParam, JsonParamEntity.class);
        this.jsonParamDao.updateJsonParam(jsonParamEntity);
    }

    public void deleteJsonParam(@NotNull String id) {
        this.jsonParamDao.deleteJsonParam(id);
    }

    public JsonParam findOne(String id) {
        JsonParamEntity jsonParamEntity = this.jsonParamDao.findJsonParam(id);
        JsonParam jsonParam = (JsonParam)BeanMapper.map((Object)jsonParamEntity, JsonParam.class);
        return jsonParam;
    }

    public List<JsonParam> findList(List<String> idList) {
        List<JsonParamEntity> jsonParamEntityList = this.jsonParamDao.findJsonParamList(idList);
        List jsonParamList = BeanMapper.mapList(jsonParamEntityList, JsonParam.class);
        return jsonParamList;
    }

    public JsonParam findJsonParam(@NotNull String id) {
        JsonParam jsonParam = this.findOne(id);
        this.joinTemplate.joinQuery((Object)jsonParam);
        return jsonParam;
    }

    public List<JsonParam> findAllJsonParam() {
        List<JsonParamEntity> jsonParamEntityList = this.jsonParamDao.findAllJsonParam();
        List jsonParamList = BeanMapper.mapList(jsonParamEntityList, JsonParam.class);
        this.joinTemplate.joinQuery(jsonParamList);
        return jsonParamList;
    }

    public List<JsonParam> findJsonParamList(JsonParamQuery jsonParamQuery) {
        List<JsonParamEntity> jsonParamEntityList = this.jsonParamDao.findJsonParamList(jsonParamQuery);
        List jsonParamList = BeanMapper.mapList(jsonParamEntityList, JsonParam.class);
        this.joinTemplate.joinQuery(jsonParamList);
        return jsonParamList;
    }

    public Pagination<JsonParam> findJsonParamPage(JsonParamQuery jsonParamQuery) {
        Pagination<JsonParamEntity> pagination = this.jsonParamDao.findJsonParamPage(jsonParamQuery);
        List jsonParamList = BeanMapper.mapList((List)pagination.getDataList(), JsonParam.class);
        this.joinTemplate.joinQuery(jsonParamList);
        return PaginationBuilder.build(pagination, (List)jsonParamList);
    }

    public List<JsonParam> findJsonParamListTree(JsonParamQuery jsonParamQuery) {
        List<JsonParam> matchJsonParamList = this.findJsonParamList(jsonParamQuery);
        List<JsonParam> topJsonParamList = this.findTopJsonParamList(matchJsonParamList);
        if (topJsonParamList != null && topJsonParamList.size() > 0) {
            for (JsonParam topJsonParam : topJsonParamList) {
                this.setChildren(matchJsonParamList, topJsonParam);
            }
        }
        return topJsonParamList;
    }

    List<JsonParam> findTopJsonParamList(List<JsonParam> matchJsonParamList) {
        List<JsonParam> jsonParamList = matchJsonParamList.stream().filter(jsonParam -> jsonParam.getParent() == null || jsonParam.getParent().getId() == null).collect(Collectors.toList());
        return jsonParamList;
    }

    void setChildren(List<JsonParam> matchJsonParamList, JsonParam parentJsonParam) {
        List childList = matchJsonParamList.stream().filter(jsonParam -> jsonParam.getParent() != null && !ObjectUtils.isEmpty((Object)jsonParam.getParent().getId()) && jsonParam.getParent().getId().equals(parentJsonParam.getId())).collect(Collectors.toList());
        if (childList != null && childList.size() > 0) {
            parentJsonParam.setChildren(childList);
            for (JsonParam childJsonParam : childList) {
                this.setChildren(matchJsonParamList, childJsonParam);
            }
        }
    }
}

