/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.apix.http.unit.cases.dao.FormParamDao;
import io.tiklab.teston.test.apix.http.unit.cases.entity.FormParamsEntity;
import io.tiklab.teston.test.apix.http.unit.cases.model.FormParam;
import io.tiklab.teston.test.apix.http.unit.cases.model.FormParamQuery;
import io.tiklab.teston.test.apix.http.unit.cases.service.FormParamService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class FormParamServiceImpl
implements FormParamService {
    @Autowired
    FormParamDao formParamDao;
    @Autowired
    JoinTemplate joinTemplate;

    public String createFormParam(@NotNull @Valid FormParam formParam) {
        FormParamsEntity formParamsEntity = (FormParamsEntity)BeanMapper.map((Object)formParam, FormParamsEntity.class);
        return this.formParamDao.createFormParam(formParamsEntity);
    }

    public void updateFormParam(@NotNull @Valid FormParam formParam) {
        FormParamsEntity formParamsEntity = (FormParamsEntity)BeanMapper.map((Object)formParam, FormParamsEntity.class);
        this.formParamDao.updateFormParam(formParamsEntity);
    }

    public void deleteFormParam(@NotNull String id) {
        this.formParamDao.deleteFormParam(id);
    }

    public FormParam findOne(String id) {
        FormParamsEntity formParamsEntity = this.formParamDao.findFormParam(id);
        FormParam formParam = (FormParam)BeanMapper.map((Object)formParamsEntity, FormParam.class);
        return formParam;
    }

    public List<FormParam> findList(List<String> idList) {
        List<FormParamsEntity> formParamsEntityList = this.formParamDao.findFormParamList(idList);
        List formParamList = BeanMapper.mapList(formParamsEntityList, FormParam.class);
        return formParamList;
    }

    public FormParam findFormParam(@NotNull String id) {
        FormParam formParam = this.findOne(id);
        this.joinTemplate.joinQuery((Object)formParam);
        return formParam;
    }

    public List<FormParam> findAllFormParam() {
        List<FormParamsEntity> formParamsEntityList = this.formParamDao.findAllFormParam();
        List formParamList = BeanMapper.mapList(formParamsEntityList, FormParam.class);
        this.joinTemplate.joinQuery(formParamList);
        return formParamList;
    }

    public List<FormParam> findFormParamList(FormParamQuery formParamQuery) {
        List<FormParamsEntity> formParamsEntityList = this.formParamDao.findFormParamList(formParamQuery);
        List formParamList = BeanMapper.mapList(formParamsEntityList, FormParam.class);
        this.joinTemplate.joinQuery(formParamList);
        return formParamList;
    }

    public Pagination<FormParam> findFormParamPage(FormParamQuery formParamQuery) {
        Pagination<FormParamsEntity> pagination = this.formParamDao.findFormParamPage(formParamQuery);
        List formParamList = BeanMapper.mapList((List)pagination.getDataList(), FormParam.class);
        this.joinTemplate.joinQuery(formParamList);
        return PaginationBuilder.build(pagination, (List)formParamList);
    }
}

