/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.service;

import com.alibaba.fastjson.JSONObject;
import io.tiklab.beans.BeanMapper;
import io.tiklab.core.exception.ApplicationException;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.apix.http.unit.cases.dao.ApiUnitCaseDao;
import io.tiklab.teston.test.apix.http.unit.cases.entity.ApiUnitCaseEntity;
import io.tiklab.teston.test.apix.http.unit.cases.model.AfterScript;
import io.tiklab.teston.test.apix.http.unit.cases.model.ApiUnitCase;
import io.tiklab.teston.test.apix.http.unit.cases.model.ApiUnitCaseDataConstruction;
import io.tiklab.teston.test.apix.http.unit.cases.model.ApiUnitCaseQuery;
import io.tiklab.teston.test.apix.http.unit.cases.model.FormParam;
import io.tiklab.teston.test.apix.http.unit.cases.model.FormParamQuery;
import io.tiklab.teston.test.apix.http.unit.cases.model.FormUrlEncoded;
import io.tiklab.teston.test.apix.http.unit.cases.model.FormUrlencodedQuery;
import io.tiklab.teston.test.apix.http.unit.cases.model.JsonParam;
import io.tiklab.teston.test.apix.http.unit.cases.model.JsonParamQuery;
import io.tiklab.teston.test.apix.http.unit.cases.model.PreScript;
import io.tiklab.teston.test.apix.http.unit.cases.model.RawParam;
import io.tiklab.teston.test.apix.http.unit.cases.model.RequestBody;
import io.tiklab.teston.test.apix.http.unit.cases.model.ResponseResult;
import io.tiklab.teston.test.apix.http.unit.cases.service.AfterScriptService;
import io.tiklab.teston.test.apix.http.unit.cases.service.ApiUnitCaseService;
import io.tiklab.teston.test.apix.http.unit.cases.service.FormParamService;
import io.tiklab.teston.test.apix.http.unit.cases.service.FormUrlencodedService;
import io.tiklab.teston.test.apix.http.unit.cases.service.JsonParamService;
import io.tiklab.teston.test.apix.http.unit.cases.service.PreScriptService;
import io.tiklab.teston.test.apix.http.unit.cases.service.QueryParamService;
import io.tiklab.teston.test.apix.http.unit.cases.service.RawParamService;
import io.tiklab.teston.test.apix.http.unit.cases.service.RequestBodyService;
import io.tiklab.teston.test.apix.http.unit.cases.service.RequestHeaderService;
import io.tiklab.teston.test.apix.http.unit.cases.service.ResponseResultServiceImpl;
import io.tiklab.teston.test.apix.http.unit.instance.dao.ApiUnitInstanceDao;
import io.tiklab.teston.test.apix.http.unit.instance.service.ApiUnitInstanceService;
import io.tiklab.teston.test.test.model.TestCase;
import io.tiklab.teston.test.test.model.TestCaseQuery;
import io.tiklab.teston.test.test.service.TestCaseService;
import java.io.FileInputStream;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.script.Bindings;
import javax.script.Invocable;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ApiUnitCaseServiceImpl
implements ApiUnitCaseService {
    @Autowired
    ApiUnitCaseDao apiApiUnitCaseDao;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    TestCaseService testCaseService;
    @Autowired
    RequestHeaderService requestHeaderService;
    @Autowired
    RequestBodyService requestBodyService;
    @Autowired
    QueryParamService queryParamService;
    @Autowired
    RawParamService rawParamService;
    @Autowired
    FormParamService formParamService;
    @Autowired
    FormUrlencodedService formUrlencodedService;
    @Autowired
    JsonParamService jsonParamService;
    @Autowired
    PreScriptService preScriptService;
    @Autowired
    AfterScriptService afterScriptService;
    @Autowired
    ResponseResultServiceImpl responseResultService;
    @Autowired
    ApiUnitInstanceDao testInstanceDao;
    @Autowired
    ApiUnitInstanceService apiUnitInstanceService;

    public String createApiUnitCase(@NotNull @Valid ApiUnitCase apiUnitCase) {
        ApiUnitCaseEntity apiUnitCaseEntity = (ApiUnitCaseEntity)BeanMapper.map((Object)apiUnitCase, ApiUnitCaseEntity.class);
        String id = this.apiApiUnitCaseDao.createApiUnitCase(apiUnitCaseEntity);
        apiUnitCaseEntity.setTestCaseId(id);
        apiUnitCaseEntity.setId(id);
        this.apiApiUnitCaseDao.updateApiUnitCase(apiUnitCaseEntity);
        RequestBody requestBody = new RequestBody();
        requestBody.setId(id);
        requestBody.setApiUnitId(id);
        requestBody.setBodyType("none");
        this.requestBodyService.createRequestBody(requestBody);
        ResponseResult responseResult = new ResponseResult();
        responseResult.setId(id);
        responseResult.setApiUnitId(id);
        responseResult.setResultType("json");
        this.responseResultService.createResponseResult(responseResult);
        TestCase testCase = apiUnitCase.getTestCase();
        testCase.setId(id);
        this.testCaseService.createTestCase(testCase);
        return id;
    }

    public void updateApiUnitCase(@NotNull @Valid ApiUnitCase apiUnitCase) {
        ApiUnitCaseEntity apiUnitCaseEntity = (ApiUnitCaseEntity)BeanMapper.map((Object)apiUnitCase, ApiUnitCaseEntity.class);
        apiUnitCaseEntity.setTestCaseId(apiUnitCase.getId());
        this.apiApiUnitCaseDao.updateApiUnitCase(apiUnitCaseEntity);
        this.testCaseService.updateTestCase(apiUnitCase.getTestCase());
    }

    public void deleteApiUnitCase(@NotNull String id) {
        this.apiApiUnitCaseDao.deleteApiUnitCase(id);
        this.testCaseService.deleteTestCase(id);
    }

    public ApiUnitCase findOne(String id) {
        ApiUnitCaseEntity apiUnitCase = this.apiApiUnitCaseDao.findApiUnitCase(id);
        ApiUnitCase apiUnit = (ApiUnitCase)BeanMapper.map((Object)apiUnitCase, ApiUnitCase.class);
        return apiUnit;
    }

    public List<ApiUnitCase> findList(List<String> idList) {
        List<ApiUnitCaseEntity> apiUnitCaseList = this.apiApiUnitCaseDao.findApiUnitCaseList(idList);
        List apiUnitList = BeanMapper.mapList(apiUnitCaseList, ApiUnitCase.class);
        return apiUnitList;
    }

    public ApiUnitCase findApiUnitCase(@NotNull String id) {
        ApiUnitCase apiUnitCase = this.findOne(id);
        this.joinTemplate.joinQuery((Object)apiUnitCase);
        TestCase testCase = this.testCaseService.findTestCase(id);
        apiUnitCase.setTestCase(testCase);
        return apiUnitCase;
    }

    public List<ApiUnitCase> findAllApiUnitCase() {
        List<ApiUnitCaseEntity> apiUnitCaseList = this.apiApiUnitCaseDao.findAllApiUnitCase();
        List apiUnitList = BeanMapper.mapList(apiUnitCaseList, ApiUnitCase.class);
        this.joinTemplate.joinQuery(apiUnitList);
        return apiUnitList;
    }

    public List<ApiUnitCase> findApiUnitCaseList(ApiUnitCaseQuery apiUnitCaseQuery) {
        List<ApiUnitCaseEntity> apiUnitCaseList = this.apiApiUnitCaseDao.findApiUnitCaseList(apiUnitCaseQuery);
        List testCases = BeanMapper.mapList(apiUnitCaseList, ApiUnitCase.class);
        this.joinTemplate.joinQuery(testCases);
        return testCases;
    }

    public List<ApiUnitCase> findApiUnitCaseListByTestCase(TestCaseQuery testCaseQuery) {
        List testCaseList = this.testCaseService.findTestCaseList(testCaseQuery);
        ArrayList<ApiUnitCase> apiUnitCaseList = new ArrayList<ApiUnitCase>();
        if (!ObjectUtils.isEmpty((Object)testCaseList)) {
            for (TestCase testCase : testCaseList) {
                List<ApiUnitCase> caseList = this.findApiUnitCaseList(new ApiUnitCaseQuery().setTestCaseId(testCase.getId()));
                if (ObjectUtils.isEmpty(caseList)) continue;
                apiUnitCaseList.add(caseList.get(0));
            }
        }
        return apiUnitCaseList;
    }

    public Pagination<ApiUnitCase> findApiUnitCasePage(ApiUnitCaseQuery testCaseQuery) {
        Pagination<ApiUnitCaseEntity> pagination = this.apiApiUnitCaseDao.findApiUnitCasePage(testCaseQuery);
        List apiUnitCaseList = BeanMapper.mapList((List)pagination.getDataList(), ApiUnitCase.class);
        this.joinTemplate.joinQuery(apiUnitCaseList);
        return PaginationBuilder.build(pagination, (List)apiUnitCaseList);
    }

    public ApiUnitCaseDataConstruction findApiUnitCaseExt(ApiUnitCase apiUnitCase) {
        Map headerMap = this.requestHeaderService.jointHeader(apiUnitCase);
        String query = this.queryParamService.jointParam(apiUnitCase);
        Map mediaType = this.jointMediaType(apiUnitCase);
        String body = this.bodyConstruction(apiUnitCase);
        Map<String, Object> preScript = this.processPreScript(apiUnitCase.getId());
        String afterScript = this.processAfterScript(apiUnitCase.getId());
        if (preScript != null && preScript.get("header") != null) {
            Object header = preScript.get("header");
            headerMap.putAll((Map)header);
        }
        ApiUnitCaseDataConstruction apiUnitCaseDataConstruction = new ApiUnitCaseDataConstruction();
        apiUnitCaseDataConstruction.setHeaderMap(headerMap);
        apiUnitCaseDataConstruction.setQuery(query);
        apiUnitCaseDataConstruction.setMediaTypeMap(mediaType);
        apiUnitCaseDataConstruction.setBody(body);
        apiUnitCaseDataConstruction.setAfterScript(afterScript);
        return apiUnitCaseDataConstruction;
    }

    Map jointMediaType(ApiUnitCase apiUnitCase) {
        RequestBody bodyType = this.requestBodyService.findRequestBody(apiUnitCase.getId());
        RawParam rawParam = this.rawParamService.findRawParam(apiUnitCase.getId());
        String rawMediaType = null;
        if (!ObjectUtils.isEmpty((Object)rawParam)) {
            rawMediaType = rawParam.getType();
        }
        HashMap<String, String> mediaType = new HashMap<String, String>();
        if (!ObjectUtils.isEmpty((Object)bodyType)) {
            if (bodyType.getBodyType().equals("raw")) {
                mediaType.put("mediaType", rawMediaType);
            } else {
                mediaType.put("mediaType", bodyType.getBodyType());
            }
        }
        return mediaType;
    }

    private String bodyConstruction(ApiUnitCase apiUnitCase) {
        RequestBody bodyType = this.requestBodyService.findRequestBody(apiUnitCase.getId());
        String bodyStr = "";
        if (!ObjectUtils.isEmpty((Object)bodyType)) {
            switch (bodyType.getBodyType()) {
                case "formdata": {
                    return this.getFormData(apiUnitCase, bodyStr);
                }
                case "formUrlencoded": {
                    return this.getFormUrlencoded(apiUnitCase, bodyStr);
                }
                case "raw": {
                    return this.getRaw(apiUnitCase, bodyStr);
                }
            }
        }
        return null;
    }

    private String getFormData(ApiUnitCase apiUnitCase, String bodyStr) {
        FormParamQuery formParamQuery = new FormParamQuery();
        formParamQuery.setApiUnitId(apiUnitCase.getId());
        List formParamList = this.formParamService.findFormParamList(formParamQuery);
        if (CollectionUtils.isNotEmpty((Collection)formParamList)) {
            for (FormParam formParam : formParamList) {
                bodyStr = (String)bodyStr + formParam.getParamName() + "=" + formParam.getValue() + "&";
            }
        }
        return bodyStr;
    }

    private String getFormUrlencoded(ApiUnitCase apiUnitCase, String bodyStr) {
        FormUrlencodedQuery formUrlencodedQuery = new FormUrlencodedQuery();
        formUrlencodedQuery.setApiUnitId(apiUnitCase.getId());
        List formUrlEncodedList = this.formUrlencodedService.findFormUrlencodedList(formUrlencodedQuery);
        if (CollectionUtils.isNotEmpty((Collection)formUrlEncodedList)) {
            for (FormUrlEncoded formUrlencoded : formUrlEncodedList) {
                bodyStr = (String)bodyStr + formUrlencoded.getParamName() + "=" + formUrlencoded.getValue() + "&";
            }
        }
        return bodyStr;
    }

    private String getJson(ApiUnitCase apiUnitCase, String bodyStr) {
        JsonParamQuery jsonParamQuery = new JsonParamQuery();
        jsonParamQuery.setApiUnitId(apiUnitCase.getId());
        List jsonParamListTree = this.jsonParamService.findJsonParamListTree(jsonParamQuery);
        if (CollectionUtils.isNotEmpty((Collection)jsonParamListTree)) {
            JSONObject jsonObject = new JSONObject();
            for (JsonParam jsonParam : jsonParamListTree) {
                this.getJsonTree(jsonParam, jsonObject);
            }
            bodyStr = jsonObject.toJSONString();
        }
        return bodyStr;
    }

    private void getJsonTree(JsonParam jsonParam, JSONObject jsonObject) {
        if (ObjectUtils.isEmpty((Object)jsonParam.getParent())) {
            String key = jsonParam.getParamName();
            String value = jsonParam.getValue();
            jsonObject.put(key, (Object)value);
        } else {
            this.getJsonTree(jsonParam.getParent(), jsonObject);
        }
    }

    private String getRaw(ApiUnitCase apiUnitCase, String bodyStr) {
        RawParam rawParam = this.rawParamService.findRawParam(apiUnitCase.getId());
        if (!ObjectUtils.isEmpty((Object)rawParam)) {
            String raw;
            bodyStr = raw = rawParam.getRaw();
        }
        return bodyStr;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private Map<String, Object> processPreScript(String caseId) {
        PreScript preScript = this.preScriptService.findPreScript(caseId);
        if (preScript != null) {
            String script = preScript.getScriptex();
            ScriptEngineManager manager = new ScriptEngineManager();
            ScriptEngine engine = manager.getEngineByName("JavaScript");
            URL resourceUrl = this.getClass().getClassLoader().getResource("static/script.js");
            String path = resourceUrl.getPath();
            try (FileInputStream fip = new FileInputStream(path);){
                Map map;
                try (InputStreamReader reader = new InputStreamReader((InputStream)fip, StandardCharsets.UTF_8);){
                    Map resultMap;
                    engine.eval(reader);
                    engine.put("to", engine.get("to"));
                    engine.eval(script);
                    Invocable invocable = (Invocable)((Object)engine);
                    Object result = invocable.invokeMethod(engine.get("to"), "getData", new Object[0]);
                    Bindings bindings = engine.createBindings();
                    bindings.put("result", result);
                    map = resultMap = (Map)engine.eval("JSON.parse(JSON.stringify(result))", bindings);
                }
                return map;
            }
            catch (Exception e) {
                throw new ApplicationException((Throwable)e);
            }
        }
        return null;
    }

    private String processAfterScript(String caseId) {
        String script = null;
        AfterScript afterScript = this.afterScriptService.findAfterScript(caseId);
        if (afterScript != null) {
            script = afterScript.getScriptex();
        }
        return script;
    }
}

