/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.dao;

import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.dal.jpa.criterial.condition.DeleteCondition;
import io.tiklab.dal.jpa.criterial.condition.QueryCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.QueryBuilders;
import io.tiklab.teston.test.apix.http.unit.cases.entity.RawResponseEntity;
import io.tiklab.teston.test.apix.http.unit.cases.model.RawResponseQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class RawResponseDao {
    private static Logger logger = LoggerFactory.getLogger(RawResponseDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createRawResponse(RawResponseEntity rawResponseEntity) {
        return (String)this.jpaTemplate.save((Object)rawResponseEntity, String.class);
    }

    public void updateRawResponse(RawResponseEntity rawResponseEntity) {
        this.jpaTemplate.update((Object)rawResponseEntity);
    }

    public void deleteRawResponse(String id) {
        this.jpaTemplate.delete(RawResponseEntity.class, (Object)id);
    }

    public void deleteRawResponse(DeleteCondition deleteCondition) {
        this.jpaTemplate.delete(deleteCondition);
    }

    public RawResponseEntity findRawResponse(String id) {
        return (RawResponseEntity)this.jpaTemplate.findOne(RawResponseEntity.class, (Object)id);
    }

    public List<RawResponseEntity> findAllRawResponse() {
        return this.jpaTemplate.findAll(RawResponseEntity.class);
    }

    public List<RawResponseEntity> findRawResponseList(List<String> idList) {
        return this.jpaTemplate.findList(RawResponseEntity.class, idList);
    }

    public List<RawResponseEntity> findRawResponseList(RawResponseQuery rawResponseQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(RawResponseEntity.class).eq("apiUnitId", (Object)rawResponseQuery.getApiUnitId()).orders(rawResponseQuery.getOrderParams()).get();
        return this.jpaTemplate.findList(queryCondition, RawResponseEntity.class);
    }

    public Pagination<RawResponseEntity> findRawResponsePage(RawResponseQuery rawResponseQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(RawResponseEntity.class).eq("apiUnitId", (Object)rawResponseQuery.getApiUnitId()).orders(rawResponseQuery.getOrderParams()).pagination(rawResponseQuery.getPageParam()).get();
        return this.jpaTemplate.findPage(queryCondition, RawResponseEntity.class);
    }
}

