/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.dao;

import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.dal.jpa.criterial.condition.DeleteCondition;
import io.tiklab.dal.jpa.criterial.condition.QueryCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.QueryBuilders;
import io.tiklab.teston.test.apix.http.unit.cases.entity.PreScriptEntity;
import io.tiklab.teston.test.apix.http.unit.cases.model.PreScriptQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class PreScriptDao {
    private static Logger logger = LoggerFactory.getLogger(PreScriptDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createPreScript(PreScriptEntity preScriptEntity) {
        return (String)this.jpaTemplate.save((Object)preScriptEntity, String.class);
    }

    public void updatePreScript(PreScriptEntity preScriptEntity) {
        this.jpaTemplate.update((Object)preScriptEntity);
    }

    public void deletePreScript(String id) {
        this.jpaTemplate.delete(PreScriptEntity.class, (Object)id);
    }

    public void deletePreScript(DeleteCondition deleteCondition) {
        this.jpaTemplate.delete(deleteCondition);
    }

    public PreScriptEntity findPreScript(String id) {
        return (PreScriptEntity)this.jpaTemplate.findOne(PreScriptEntity.class, (Object)id);
    }

    public List<PreScriptEntity> findAllPreScript() {
        return this.jpaTemplate.findAll(PreScriptEntity.class);
    }

    public List<PreScriptEntity> findPreScriptList(List<String> idList) {
        return this.jpaTemplate.findList(PreScriptEntity.class, idList);
    }

    public List<PreScriptEntity> findPreScriptList(PreScriptQuery preScriptQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(PreScriptEntity.class).eq("apiUnitId", (Object)preScriptQuery.getApiUnitId()).orders(preScriptQuery.getOrderParams()).get();
        return this.jpaTemplate.findList(queryCondition, PreScriptEntity.class);
    }

    public Pagination<PreScriptEntity> findPreScriptPage(PreScriptQuery preScriptQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(PreScriptEntity.class).eq("apiUnitId", (Object)preScriptQuery.getApiUnitId()).orders(preScriptQuery.getOrderParams()).pagination(preScriptQuery.getPageParam()).get();
        return this.jpaTemplate.findPage(queryCondition, PreScriptEntity.class);
    }
}

