/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.dao;

import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.dal.jpa.criterial.condition.DeleteCondition;
import io.tiklab.dal.jpa.criterial.condition.QueryCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.QueryBuilders;
import io.tiklab.teston.test.apix.http.unit.cases.entity.JsonResponseEntity;
import io.tiklab.teston.test.apix.http.unit.cases.model.JsonResponseQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class JsonResponseDao {
    private static Logger logger = LoggerFactory.getLogger(JsonResponseDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createJsonResponse(JsonResponseEntity jsonResponseEntity) {
        return (String)this.jpaTemplate.save((Object)jsonResponseEntity, String.class);
    }

    public void updateJsonResponse(JsonResponseEntity jsonResponseEntity) {
        this.jpaTemplate.update((Object)jsonResponseEntity);
    }

    public void deleteJsonResponse(String id) {
        this.jpaTemplate.delete(JsonResponseEntity.class, (Object)id);
    }

    public void deleteJsonResponse(DeleteCondition deleteCondition) {
        this.jpaTemplate.delete(deleteCondition);
    }

    public JsonResponseEntity findJsonResponse(String id) {
        return (JsonResponseEntity)this.jpaTemplate.findOne(JsonResponseEntity.class, (Object)id);
    }

    public List<JsonResponseEntity> findAllJsonResponse() {
        return this.jpaTemplate.findAll(JsonResponseEntity.class);
    }

    public List<JsonResponseEntity> findJsonResponseList(List<String> idList) {
        return this.jpaTemplate.findList(JsonResponseEntity.class, idList);
    }

    public List<JsonResponseEntity> findJsonResponseList(JsonResponseQuery jsonResponseQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(JsonResponseEntity.class).eq("apiUnitId", (Object)jsonResponseQuery.getApiUnitId()).orders(jsonResponseQuery.getOrderParams()).get();
        return this.jpaTemplate.findList(queryCondition, JsonResponseEntity.class);
    }

    public Pagination<JsonResponseEntity> findJsonResponsePage(JsonResponseQuery jsonResponseQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(JsonResponseEntity.class).eq("apiUnitId", (Object)jsonResponseQuery.getApiUnitId()).orders(jsonResponseQuery.getOrderParams()).pagination(jsonResponseQuery.getPageParam()).get();
        return this.jpaTemplate.findPage(queryCondition, JsonResponseEntity.class);
    }
}

