/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.test.apix.http.unit.cases.model.RequestHeader;
import io.tiklab.teston.test.apix.http.unit.cases.model.RequestHeaderQuery;
import io.tiklab.teston.test.apix.http.unit.cases.service.RequestHeaderService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/requestHeader"})
@Api(name="RequestHeaderController", desc="\u63a5\u53e3\u7528\u4f8b\u6b65\u9aa4RequestHeaderController")
public class RequestHeaderController {
    private static Logger logger = LoggerFactory.getLogger(RequestHeaderController.class);
    @Autowired
    private RequestHeaderService requestHeaderService;

    @RequestMapping(path={"/createRequestHeader"}, method={RequestMethod.POST})
    @ApiMethod(name="createRequestHeader", desc="\u521b\u5efa\u8bf7\u6c42\u5934")
    @ApiParam(name="requestHeader", desc="requestHeader", required=true)
    public Result<String> createRequestHeader(@RequestBody @NotNull @Valid RequestHeader requestHeader) {
        String id = this.requestHeaderService.createRequestHeader(requestHeader);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateRequestHeader"}, method={RequestMethod.POST})
    @ApiMethod(name="updateRequestHeader", desc="\u66f4\u65b0\u8bf7\u6c42\u5934")
    @ApiParam(name="requestHeader", desc="requestHeader", required=true)
    public Result<Void> updateRequestHeader(@RequestBody @NotNull @Valid RequestHeader requestHeader) {
        this.requestHeaderService.updateRequestHeader(requestHeader);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteRequestHeader"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteRequestHeader", desc="\u5220\u9664\u8bf7\u6c42\u5934")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteRequestHeader(@NotNull String id) {
        this.requestHeaderService.deleteRequestHeader(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findRequestHeader"}, method={RequestMethod.POST})
    @ApiMethod(name="findRequestHeader", desc="\u67e5\u627e\u8bf7\u6c42\u5934")
    @ApiParam(name="id", desc="id", required=true)
    public Result<RequestHeader> findRequestHeader(@NotNull String id) {
        RequestHeader requestHeader = this.requestHeaderService.findRequestHeader(id);
        return Result.ok((Object)requestHeader);
    }

    @RequestMapping(path={"/findAllRequestHeader"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllRequestHeader", desc="\u67e5\u627e\u6240\u6709\u8bf7\u6c42\u5934")
    public Result<List<RequestHeader>> findAllRequestHeader() {
        List requestHeaderList = this.requestHeaderService.findAllRequestHeader();
        return Result.ok((Object)requestHeaderList);
    }

    @RequestMapping(path={"/findRequestHeaderList"}, method={RequestMethod.POST})
    @ApiMethod(name="findRequestHeaderList", desc="\u6839\u636e\u53c2\u6570\u67e5\u8be2\u8bf7\u6c42\u5934\u5217\u8868")
    @ApiParam(name="requestHeaderQuery", desc="requestHeaderQuery", required=true)
    public Result<List<RequestHeader>> findRequestHeaderList(@RequestBody @Valid @NotNull RequestHeaderQuery requestHeaderQuery) {
        List requestHeaderList = this.requestHeaderService.findRequestHeaderList(requestHeaderQuery);
        return Result.ok((Object)requestHeaderList);
    }

    @RequestMapping(path={"/findRequestHeaderPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findRequestHeaderPage", desc="\u6839\u636e\u53c2\u6570\u6309\u5206\u9875\u67e5\u8be2\u8bf7\u6c42\u5934")
    @ApiParam(name="requestHeaderQuery", desc="requestHeaderQuery", required=true)
    public Result<Pagination<RequestHeader>> findRequestHeaderPage(@RequestBody @Valid @NotNull RequestHeaderQuery requestHeaderQuery) {
        Pagination pagination = this.requestHeaderService.findRequestHeaderPage(requestHeaderQuery);
        return Result.ok((Object)pagination);
    }
}

