/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.test.apix.http.unit.cases.model.RawParam;
import io.tiklab.teston.test.apix.http.unit.cases.model.RawParamQuery;
import io.tiklab.teston.test.apix.http.unit.cases.service.RawParamService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/rawParam"})
@Api(name="RawParamController", desc="\u63a5\u53e3\u7528\u4f8b\u6b65\u9aa4RawParamController")
public class RawParamController {
    private static Logger logger = LoggerFactory.getLogger(RawParamController.class);
    @Autowired
    private RawParamService rawParamService;

    @RequestMapping(path={"/createRawParam"}, method={RequestMethod.POST})
    @ApiMethod(name="createRawParam", desc="\u521b\u5efaraw")
    @ApiParam(name="rawParam", desc="rawParam", required=true)
    public Result<String> createRawParam(@RequestBody @NotNull @Valid RawParam rawParam) {
        String id = this.rawParamService.createRawParam(rawParam);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateRawParam"}, method={RequestMethod.POST})
    @ApiMethod(name="updateRawParam", desc="\u66f4\u65b0raw")
    @ApiParam(name="rawParam", desc="rawParam", required=true)
    public Result<Void> updateRawParam(@RequestBody @NotNull @Valid RawParam rawParam) {
        this.rawParamService.updateRawParam(rawParam);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteRawParam"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteRawParam", desc="\u5220\u9664raw")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteRawParam(@NotNull String id) {
        this.rawParamService.deleteRawParam(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findRawParam"}, method={RequestMethod.POST})
    @ApiMethod(name="findRawParam", desc="\u6839\u636eid\u67e5\u627eraw")
    @ApiParam(name="id", desc="id", required=true)
    public Result<RawParam> findRawParam(@NotNull String id) {
        RawParam rawParam = this.rawParamService.findRawParam(id);
        return Result.ok((Object)rawParam);
    }

    @RequestMapping(path={"/findAllRawParam"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllRawParam", desc="\u67e5\u627e\u6240\u6709raw")
    public Result<List<RawParam>> findAllRawParam() {
        List rawParamList = this.rawParamService.findAllRawParam();
        return Result.ok((Object)rawParamList);
    }

    @RequestMapping(path={"/findRawParamList"}, method={RequestMethod.POST})
    @ApiMethod(name="findRawParamList", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u67e5\u8be2raw\u5217\u8868")
    @ApiParam(name="rawParamQuery", desc="rawParamQuery", required=true)
    public Result<List<RawParam>> findRawParamList(@RequestBody @Valid @NotNull RawParamQuery rawParamQuery) {
        List rawParamList = this.rawParamService.findRawParamList(rawParamQuery);
        return Result.ok((Object)rawParamList);
    }

    @RequestMapping(path={"/findRawParamPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findRawParamPage", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u6309\u5206\u9875\u67e5\u8be2raw")
    @ApiParam(name="rawParamQuery", desc="rawParamQuery", required=true)
    public Result<Pagination<RawParam>> findRawParamPage(@RequestBody @Valid @NotNull RawParamQuery rawParamQuery) {
        Pagination pagination = this.rawParamService.findRawParamPage(rawParamQuery);
        return Result.ok((Object)pagination);
    }
}

