/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.test.apix.http.unit.cases.model.QueryParamQuery;
import io.tiklab.teston.test.apix.http.unit.cases.model.QueryParams;
import io.tiklab.teston.test.apix.http.unit.cases.service.QueryParamService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/queryParam"})
@Api(name="QueryParamController", desc="\u63a5\u53e3\u7528\u4f8b\u6b65\u9aa4QueryParamController")
public class QueryParamController {
    private static Logger logger = LoggerFactory.getLogger(QueryParamController.class);
    @Autowired
    private QueryParamService queryParamService;

    @RequestMapping(path={"/createQueryParam"}, method={RequestMethod.POST})
    @ApiMethod(name="createQueryParam", desc="\u521b\u5efaquery")
    @ApiParam(name="queryParams", desc="queryParams", required=true)
    public Result<String> createQueryParam(@RequestBody @NotNull @Valid QueryParams queryParams) {
        String id = this.queryParamService.createQueryParam(queryParams);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateQueryParam"}, method={RequestMethod.POST})
    @ApiMethod(name="updateQueryParam", desc="\u66f4\u65b0query")
    @ApiParam(name="queryParams", desc="queryParams", required=true)
    public Result<Void> updateQueryParam(@RequestBody @NotNull @Valid QueryParams queryParams) {
        this.queryParamService.updateQueryParam(queryParams);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteQueryParam"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteQueryParam", desc="\u5220\u9664query")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteQueryParam(@NotNull String id) {
        this.queryParamService.deleteQueryParam(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findQueryParam"}, method={RequestMethod.POST})
    @ApiMethod(name="findQueryParam", desc="\u6839\u636eid\u67e5\u627equery")
    @ApiParam(name="id", desc="id", required=true)
    public Result<QueryParams> findQueryParam(@NotNull String id) {
        QueryParams queryParams = this.queryParamService.findQueryParam(id);
        return Result.ok((Object)queryParams);
    }

    @RequestMapping(path={"/findAllQueryParam"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllQueryParam", desc="\u67e5\u627e\u6240\u6709query")
    public Result<List<QueryParams>> findAllQueryParam() {
        List queryParamsList = this.queryParamService.findAllQueryParam();
        return Result.ok((Object)queryParamsList);
    }

    @RequestMapping(path={"/findQueryParamList"}, method={RequestMethod.POST})
    @ApiMethod(name="findQueryParamList", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u67e5\u8be2query\u5217\u8868")
    @ApiParam(name="queryParamQuery", desc="queryParamQuery", required=true)
    public Result<List<QueryParams>> findQueryParamList(@RequestBody @Valid @NotNull QueryParamQuery queryParamQuery) {
        List queryParamsList = this.queryParamService.findQueryParamList(queryParamQuery);
        return Result.ok((Object)queryParamsList);
    }

    @RequestMapping(path={"/findQueryParamPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findQueryParamPage", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u6309\u5206\u9875\u67e5\u8be2query")
    @ApiParam(name="queryParamQuery", desc="queryParamQuery", required=true)
    public Result<Pagination<QueryParams>> findQueryParamPage(@RequestBody @Valid @NotNull QueryParamQuery queryParamQuery) {
        Pagination pagination = this.queryParamService.findQueryParamPage(queryParamQuery);
        return Result.ok((Object)pagination);
    }
}

