/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.test.apix.http.unit.cases.model.PreScript;
import io.tiklab.teston.test.apix.http.unit.cases.model.PreScriptQuery;
import io.tiklab.teston.test.apix.http.unit.cases.service.PreScriptService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/preScript"})
@Api(name="PreScriptController", desc="\u63a5\u53e3\u7528\u4f8b\u6b65\u9aa4PreScriptController")
public class PreScriptController {
    private static Logger logger = LoggerFactory.getLogger(PreScriptController.class);
    @Autowired
    private PreScriptService preScriptService;

    @RequestMapping(path={"/createPreScript"}, method={RequestMethod.POST})
    @ApiMethod(name="createPreScript", desc="\u521b\u5efa\u524d\u7f6e\u811a\u672c")
    @ApiParam(name="preScript", desc="preScript", required=true)
    public Result<String> createPreScript(@RequestBody @NotNull @Valid PreScript preScript) {
        String id = this.preScriptService.createPreScript(preScript);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updatePreScript"}, method={RequestMethod.POST})
    @ApiMethod(name="updatePreScript", desc="\u66f4\u65b0\u524d\u7f6e\u811a\u672c")
    @ApiParam(name="preScript", desc="preScript", required=true)
    public Result<Void> updatePreScript(@RequestBody @NotNull @Valid PreScript preScript) {
        this.preScriptService.updatePreScript(preScript);
        return Result.ok();
    }

    @RequestMapping(path={"/deletePreScript"}, method={RequestMethod.POST})
    @ApiMethod(name="deletePreScript", desc="\u5220\u9664\u524d\u7f6e\u811a\u672c")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deletePreScript(@NotNull String id) {
        this.preScriptService.deletePreScript(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findPreScript"}, method={RequestMethod.POST})
    @ApiMethod(name="findPreScript", desc="\u6839\u636eid\u67e5\u627e\u524d\u7f6e\u811a\u672c")
    @ApiParam(name="id", desc="id", required=true)
    public Result<PreScript> findPreScript(@NotNull String id) {
        PreScript preScript = this.preScriptService.findPreScript(id);
        return Result.ok((Object)preScript);
    }

    @RequestMapping(path={"/findAllPreScript"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllPreScript", desc="\u67e5\u627e\u6240\u6709\u524d\u7f6e\u811a\u672c")
    public Result<List<PreScript>> findAllPreScript() {
        List preScriptList = this.preScriptService.findAllPreScript();
        return Result.ok((Object)preScriptList);
    }

    @RequestMapping(path={"/findPreScriptList"}, method={RequestMethod.POST})
    @ApiMethod(name="findPreScriptList", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u67e5\u8be2\u524d\u7f6e\u811a\u672c\u5217\u8868")
    @ApiParam(name="preScriptQuery", desc="preScriptQuery", required=true)
    public Result<List<PreScript>> findPreScriptList(@RequestBody @Valid @NotNull PreScriptQuery preScriptQuery) {
        List preScriptList = this.preScriptService.findPreScriptList(preScriptQuery);
        return Result.ok((Object)preScriptList);
    }

    @RequestMapping(path={"/findPreScriptPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findPreScriptPage", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u6309\u5206\u9875\u67e5\u8be2\u524d\u7f6e\u811a\u672c")
    @ApiParam(name="preScriptQuery", desc="preScriptQuery", required=true)
    public Result<Pagination<PreScript>> findPreScriptPage(@RequestBody @Valid @NotNull PreScriptQuery preScriptQuery) {
        Pagination pagination = this.preScriptService.findPreScriptPage(preScriptQuery);
        return Result.ok((Object)pagination);
    }
}

