/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.test.apix.http.unit.cases.model.JsonResponse;
import io.tiklab.teston.test.apix.http.unit.cases.model.JsonResponseQuery;
import io.tiklab.teston.test.apix.http.unit.cases.service.JsonResponseService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/jsonResponse"})
@Api(name="JsonResponseController", desc="\u63a5\u53e3\u7528\u4f8b\u6b65\u9aa4JsonResponseController")
public class JsonResponseController {
    private static Logger logger = LoggerFactory.getLogger(JsonResponseController.class);
    @Autowired
    private JsonResponseService jsonResponseService;

    @RequestMapping(path={"/createJsonResponse"}, method={RequestMethod.POST})
    @ApiMethod(name="createJsonResponse", desc="\u521b\u5efa\u54cd\u5e94\u4e2djson")
    @ApiParam(name="jsonResponse", desc="jsonResponse", required=true)
    public Result<String> createJsonResponse(@RequestBody @NotNull @Valid JsonResponse jsonResponse) {
        String id = this.jsonResponseService.createJsonResponse(jsonResponse);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateJsonResponse"}, method={RequestMethod.POST})
    @ApiMethod(name="updateJsonResponse", desc="\u66f4\u65b0\u54cd\u5e94\u4e2djson")
    @ApiParam(name="jsonResponse", desc="jsonResponse", required=true)
    public Result<Void> updateJsonResponse(@RequestBody @NotNull @Valid JsonResponse jsonResponse) {
        this.jsonResponseService.updateJsonResponse(jsonResponse);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteJsonResponse"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteJsonResponse", desc="\u5220\u9664\u54cd\u5e94\u4e2djson")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteJsonResponse(@NotNull String id) {
        this.jsonResponseService.deleteJsonResponse(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findJsonResponse"}, method={RequestMethod.POST})
    @ApiMethod(name="findJsonResponse", desc="\u6839\u636eid\u67e5\u627e\u54cd\u5e94\u4e2djson")
    @ApiParam(name="id", desc="id", required=true)
    public Result<JsonResponse> findJsonResponse(@NotNull String id) {
        JsonResponse jsonResponse = this.jsonResponseService.findJsonResponse(id);
        return Result.ok((Object)jsonResponse);
    }

    @RequestMapping(path={"/findAllJsonResponse"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllJsonResponse", desc="\u67e5\u627e\u6240\u6709\u54cd\u5e94\u4e2djson")
    public Result<List<JsonResponse>> findAllJsonResponse() {
        List jsonResponseList = this.jsonResponseService.findAllJsonResponse();
        return Result.ok((Object)jsonResponseList);
    }

    @RequestMapping(path={"/findJsonResponseList"}, method={RequestMethod.POST})
    @ApiMethod(name="findJsonResponseList", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u67e5\u627e\u67e5\u8be2\u54cd\u5e94\u4e2djson\u5217\u8868")
    @ApiParam(name="jsonResponseQuery", desc="jsonResponseQuery", required=true)
    public Result<List<JsonResponse>> findJsonResponseList(@RequestBody @Valid @NotNull JsonResponseQuery jsonResponseQuery) {
        List jsonResponseList = this.jsonResponseService.findJsonResponseList(jsonResponseQuery);
        return Result.ok((Object)jsonResponseList);
    }

    @RequestMapping(path={"/findJsonResponsePage"}, method={RequestMethod.POST})
    @ApiMethod(name="findJsonResponsePage", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u67e5\u627e\u6309\u5206\u9875\u67e5\u8be2\u54cd\u5e94\u4e2djson")
    @ApiParam(name="jsonResponseQuery", desc="jsonResponseQuery", required=true)
    public Result<Pagination<JsonResponse>> findJsonResponsePage(@RequestBody @Valid @NotNull JsonResponseQuery jsonResponseQuery) {
        Pagination pagination = this.jsonResponseService.findJsonResponsePage(jsonResponseQuery);
        return Result.ok((Object)pagination);
    }

    @RequestMapping(path={"/findJsonResponseListTree"}, method={RequestMethod.POST})
    @ApiMethod(name="findJsonResponseListTree", desc="\u6839\u636e\u67e5\u8be2\u5bf9\u8c61\u67e5\u8be2json\u54cd\u5e94\u7ed3\u679c\u5217\u8868\u6811")
    @ApiParam(name="jsonResponseQuery", desc="\u67e5\u8be2\u5bf9\u8c61", required=true)
    public Result<List<JsonResponse>> findJsonResponseListTree(@RequestBody @Valid @NotNull JsonResponseQuery jsonResponseQuery) {
        List jsonResponseList = this.jsonResponseService.findJsonResponseListTree(jsonResponseQuery);
        return Result.ok((Object)jsonResponseList);
    }
}

