/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.test.apix.http.unit.cases.model.FormParam;
import io.tiklab.teston.test.apix.http.unit.cases.model.FormParamQuery;
import io.tiklab.teston.test.apix.http.unit.cases.service.FormParamService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/formParam"})
@Api(name="FormParamController", desc="\u63a5\u53e3\u7528\u4f8b\u6b65\u9aa4form \u53c2\u6570\u7ba1\u7406")
public class FormParamController {
    private static Logger logger = LoggerFactory.getLogger(FormParamController.class);
    @Autowired
    private FormParamService formParamService;

    @RequestMapping(path={"/createFormParam"}, method={RequestMethod.POST})
    @ApiMethod(name="createFormParam", desc="\u521b\u5efaform-data")
    @ApiParam(name="formParam", desc="formParam", required=true)
    public Result<String> createFormParam(@RequestBody @NotNull @Valid FormParam formParam) {
        String id = this.formParamService.createFormParam(formParam);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateFormParam"}, method={RequestMethod.POST})
    @ApiMethod(name="updateFormParam", desc="\u66f4\u65b0form-data")
    @ApiParam(name="formParam", desc="formParam", required=true)
    public Result<Void> updateFormParam(@RequestBody @NotNull @Valid FormParam formParam) {
        this.formParamService.updateFormParam(formParam);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteFormParam"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteFormParam", desc="\u5220\u9664form-data")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteFormParam(@NotNull String id) {
        this.formParamService.deleteFormParam(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findFormParam"}, method={RequestMethod.POST})
    @ApiMethod(name="findFormParam", desc="\u6839\u636eid\u67e5\u627eform-data")
    @ApiParam(name="id", desc="id", required=true)
    public Result<FormParam> findFormParam(@NotNull String id) {
        FormParam formParam = this.formParamService.findFormParam(id);
        return Result.ok((Object)formParam);
    }

    @RequestMapping(path={"/findAllFormParam"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllFormParam", desc="\u67e5\u627e\u6240\u6709form-data")
    public Result<List<FormParam>> findAllFormParam() {
        List formParamList = this.formParamService.findAllFormParam();
        return Result.ok((Object)formParamList);
    }

    @RequestMapping(path={"/findFormParamList"}, method={RequestMethod.POST})
    @ApiMethod(name="findFormParamList", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u67e5\u8be2form-data\u5217\u8868")
    @ApiParam(name="formParamQuery", desc="formParamQuery", required=true)
    public Result<List<FormParam>> findFormParamList(@RequestBody @Valid @NotNull FormParamQuery formParamQuery) {
        List formParamList = this.formParamService.findFormParamList(formParamQuery);
        return Result.ok((Object)formParamList);
    }

    @RequestMapping(path={"/findFormParamPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findFormParamPage", desc="\u6839\u636e\u67e5\u8be2\u53c2\u6570\u6309\u5206\u9875\u67e5\u8be2form-data")
    @ApiParam(name="formParamQuery", desc="formParamQuery", required=true)
    public Result<Pagination<FormParam>> findFormParamPage(@RequestBody @Valid @NotNull FormParamQuery formParamQuery) {
        Pagination pagination = this.formParamService.findFormParamPage(formParamQuery);
        return Result.ok((Object)pagination);
    }
}

