/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.unit.cases.controller;

import io.tiklab.core.Result;
import io.tiklab.core.page.Pagination;
import io.tiklab.postin.annotation.Api;
import io.tiklab.postin.annotation.ApiMethod;
import io.tiklab.postin.annotation.ApiParam;
import io.tiklab.teston.test.apix.http.unit.cases.model.AssertCase;
import io.tiklab.teston.test.apix.http.unit.cases.model.AssertCaseQuery;
import io.tiklab.teston.test.apix.http.unit.cases.service.AssertService;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/assertParam"})
@Api(name="AssertCaseController", desc="\u63a5\u53e3\u7528\u4f8b\u6b65\u9aa4\u65ad\u8a00\u7ba1\u7406")
public class AssertController {
    private static Logger logger = LoggerFactory.getLogger(AssertController.class);
    @Autowired
    private AssertService assertCaseService;

    @RequestMapping(path={"/createAssertParam"}, method={RequestMethod.POST})
    @ApiMethod(name="createAssertCase", desc="\u521b\u5efa\u65ad\u8a00")
    @ApiParam(name="assertCase", desc="assertCase", required=true)
    public Result<String> createAssertCase(@RequestBody @NotNull @Valid AssertCase assertCase) {
        String id = this.assertCaseService.createAssertCase(assertCase);
        return Result.ok((Object)id);
    }

    @RequestMapping(path={"/updateAssertParam"}, method={RequestMethod.POST})
    @ApiMethod(name="updateAssertCase", desc="\u66f4\u65b0\u65ad\u8a00")
    @ApiParam(name="assertCase", desc="assertCase", required=true)
    public Result<Void> updateAssertCase(@RequestBody @NotNull @Valid AssertCase assertCase) {
        this.assertCaseService.updateAssertCase(assertCase);
        return Result.ok();
    }

    @RequestMapping(path={"/deleteAssertParam"}, method={RequestMethod.POST})
    @ApiMethod(name="deleteAssertCase", desc="\u5220\u9664\u65ad\u8a00")
    @ApiParam(name="id", desc="id", required=true)
    public Result<Void> deleteAssertCase(@NotNull String id) {
        this.assertCaseService.deleteAssertCase(id);
        return Result.ok();
    }

    @RequestMapping(path={"/findAssertParam"}, method={RequestMethod.POST})
    @ApiMethod(name="findAssertCase", desc="\u901a\u8fc7id\u67e5\u627e\u65ad\u8a00")
    @ApiParam(name="id", desc="id", required=true)
    public Result<AssertCase> findAssertCase(@NotNull String id) {
        AssertCase assertCase = this.assertCaseService.findAssertCase(id);
        return Result.ok((Object)assertCase);
    }

    @RequestMapping(path={"/findAllAssertParam"}, method={RequestMethod.POST})
    @ApiMethod(name="findAllAssertCase", desc="\u67e5\u627e\u6240\u6709\u65ad\u8a00")
    public Result<List<AssertCase>> findAllAssertCase() {
        List assertCaseList = this.assertCaseService.findAllAssertCase();
        return Result.ok((Object)assertCaseList);
    }

    @RequestMapping(path={"/findAssertParamList"}, method={RequestMethod.POST})
    @ApiMethod(name="findAssertCaseList", desc="\u67e5\u8be2\u65ad\u8a00\u5217\u8868")
    @ApiParam(name="assertCaseQuery", desc="assertCaseQuery", required=true)
    public Result<List<AssertCase>> findAssertCaseList(@RequestBody @Valid @NotNull AssertCaseQuery assertCaseQuery) {
        List assertCaseList = this.assertCaseService.findAssertCaseList(assertCaseQuery);
        return Result.ok((Object)assertCaseList);
    }

    @RequestMapping(path={"/findAssertParamPage"}, method={RequestMethod.POST})
    @ApiMethod(name="findAssertCasePage", desc="\u6309\u5206\u9875\u67e5\u8be2\u65ad\u8a00")
    @ApiParam(name="assertCaseQuery", desc="assertCaseQuery", required=true)
    public Result<Pagination<AssertCase>> findAssertCasePage(@RequestBody @Valid @NotNull AssertCaseQuery assertCaseQuery) {
        Pagination pagination = this.assertCaseService.findAssertCasePage(assertCaseQuery);
        return Result.ok((Object)pagination);
    }
}

