/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.scene.instance.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.eam.common.context.LoginContext;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.apix.http.scene.execute.model.ApiSceneTestResponse;
import io.tiklab.teston.test.apix.http.scene.instance.dao.ApiSceneInstanceDao;
import io.tiklab.teston.test.apix.http.scene.instance.entity.ApiSceneInstanceEntity;
import io.tiklab.teston.test.apix.http.scene.instance.model.ApiSceneInstance;
import io.tiklab.teston.test.apix.http.scene.instance.model.ApiSceneInstanceQuery;
import io.tiklab.teston.test.apix.http.scene.instance.model.ApiSceneStepInstanceBind;
import io.tiklab.teston.test.apix.http.scene.instance.model.ApiSceneStepInstanceBindQuery;
import io.tiklab.teston.test.apix.http.scene.instance.service.ApiSceneInstanceService;
import io.tiklab.teston.test.apix.http.scene.instance.service.ApiSceneStepInstanceBindService;
import io.tiklab.teston.test.apix.http.unit.cases.model.ApiUnitCase;
import io.tiklab.teston.test.apix.http.unit.cases.service.ApiUnitCaseService;
import io.tiklab.teston.test.apix.http.unit.instance.model.ApiUnitInstance;
import io.tiklab.teston.test.apix.http.unit.instance.service.ApiUnitInstanceService;
import io.tiklab.teston.test.test.service.TestCaseService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiSceneInstanceServiceImpl
implements ApiSceneInstanceService {
    @Autowired
    ApiSceneInstanceDao apiSceneInstanceDao;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    ApiUnitInstanceService apiUnitInstanceService;
    @Autowired
    ApiSceneStepInstanceBindService apiSceneStepInstanceBindService;
    @Autowired
    TestCaseService unitCaseService;
    @Autowired
    ApiUnitCaseService apiUnitCaseService;

    public String createApiSceneInstance(@NotNull @Valid ApiSceneInstance scenInstance) {
        ApiSceneInstanceEntity apiSceneInstanceEntity = (ApiSceneInstanceEntity)BeanMapper.map((Object)scenInstance, ApiSceneInstanceEntity.class);
        apiSceneInstanceEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        String userId = LoginContext.getLoginId();
        apiSceneInstanceEntity.setCreateUser(userId);
        return this.apiSceneInstanceDao.createTestInstance(apiSceneInstanceEntity);
    }

    public void updateApiSceneInstance(@NotNull @Valid ApiSceneInstance scenInstance) {
        ApiSceneInstanceEntity testInstanceEntity = (ApiSceneInstanceEntity)BeanMapper.map((Object)scenInstance, ApiSceneInstanceEntity.class);
        this.apiSceneInstanceDao.updateTestInstance(testInstanceEntity);
    }

    public void deleteApiSceneInstance(@NotNull String id) {
        this.apiSceneInstanceDao.deleteTestInstance(id);
    }

    public ApiSceneInstance findOne(String id) {
        ApiSceneInstanceEntity testInstanceEntity = this.apiSceneInstanceDao.findTestInstance(id);
        ApiSceneInstance testInstance = (ApiSceneInstance)BeanMapper.map((Object)testInstanceEntity, ApiSceneInstance.class);
        return testInstance;
    }

    public List<ApiSceneInstance> findList(List<String> idList) {
        List<ApiSceneInstanceEntity> testInstanceEntityList = this.apiSceneInstanceDao.findTestInstanceList(idList);
        List testInstanceList = BeanMapper.mapList(testInstanceEntityList, ApiSceneInstance.class);
        return testInstanceList;
    }

    public ApiSceneInstance findApiSceneInstance(@NotNull String id) {
        ApiSceneInstance apiSceneInstance = this.findOne(id);
        ApiSceneStepInstanceBindQuery apiSceneStepInstanceBindQuery = new ApiSceneStepInstanceBindQuery();
        apiSceneStepInstanceBindQuery.setApiSceneInstanceId(id);
        List apiSceneStepInstanceBindList = this.apiSceneStepInstanceBindService.findApiSceneStepInstanceBindList(apiSceneStepInstanceBindQuery);
        ArrayList<ApiSceneStepInstanceBind> newApiStepList = new ArrayList<ApiSceneStepInstanceBind>();
        for (ApiSceneStepInstanceBind apiSceneStepInstanceBind : apiSceneStepInstanceBindList) {
            ApiUnitCase apiUnit = apiSceneStepInstanceBind.getApiUnitInstance().getApiUnit();
            ApiUnitCase apiUnitCase = this.apiUnitCaseService.findApiUnitCase(apiUnit.getId());
            apiSceneStepInstanceBind.getApiUnitInstance().setApiUnit(apiUnitCase);
            newApiStepList.add(apiSceneStepInstanceBind);
        }
        apiSceneInstance.setStepList(newApiStepList);
        this.joinTemplate.joinQuery((Object)apiSceneInstance);
        return apiSceneInstance;
    }

    public List<ApiSceneInstance> findAllApiSceneInstance() {
        List<ApiSceneInstanceEntity> testInstanceEntities = this.apiSceneInstanceDao.findAllTestInstance();
        List testInstanceList = BeanMapper.mapList(testInstanceEntities, ApiSceneInstance.class);
        this.joinTemplate.joinQuery(testInstanceList);
        return testInstanceList;
    }

    public List<ApiSceneInstance> findApiSceneInstanceList(ApiSceneInstanceQuery apiSceneInstanceQuery) {
        List<ApiSceneInstanceEntity> testInstanceEntities = this.apiSceneInstanceDao.findTestInstanceList(apiSceneInstanceQuery);
        List testInstanceList = BeanMapper.mapList(testInstanceEntities, ApiSceneInstance.class);
        this.joinTemplate.joinQuery(testInstanceList);
        return testInstanceList;
    }

    public Pagination<ApiSceneInstance> findApiSceneInstancePage(ApiSceneInstanceQuery apiSceneInstanceQuery) {
        Pagination<ApiSceneInstanceEntity> pagination = this.apiSceneInstanceDao.findTestInstancePage(apiSceneInstanceQuery);
        List testInstanceList = BeanMapper.mapList((List)pagination.getDataList(), ApiSceneInstance.class);
        this.joinTemplate.joinQuery(testInstanceList);
        return PaginationBuilder.build(pagination, (List)testInstanceList);
    }

    public String saveApiSceneInstanceToSql(ApiSceneInstance apiSceneInstance, ApiSceneTestResponse apiSceneTestResponse) {
        String apiSceneInstanceId = this.createApiSceneInstance(apiSceneInstance);
        List apiUnitInstanceList = apiSceneTestResponse.getApiUnitInstanceList();
        apiUnitInstanceList.forEach(apiUnitInstance -> {
            String apiUnitInstanceId = this.apiUnitInstanceService.saveApiUnitInstanceToSql(apiUnitInstance);
            ApiSceneStepInstanceBind apiSceneStepInstanceBind = new ApiSceneStepInstanceBind();
            apiSceneStepInstanceBind.setApiSceneInstanceId(apiSceneInstanceId);
            ApiUnitInstance apiUnitInstance1 = new ApiUnitInstance();
            apiUnitInstance1.setId(apiUnitInstanceId);
            apiSceneStepInstanceBind.setApiUnitInstance(apiUnitInstance1);
            apiSceneStepInstanceBind.setId(apiSceneInstanceId);
            this.apiSceneStepInstanceBindService.createApiSceneStepInstanceBind(apiSceneStepInstanceBind);
        });
        return apiSceneInstanceId;
    }
}

