/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.scene.instance.dao;

import io.tiklab.core.page.Pagination;
import io.tiklab.dal.jpa.JpaTemplate;
import io.tiklab.dal.jpa.criterial.condition.DeleteCondition;
import io.tiklab.dal.jpa.criterial.condition.QueryCondition;
import io.tiklab.dal.jpa.criterial.conditionbuilder.QueryBuilders;
import io.tiklab.teston.test.apix.http.scene.instance.entity.ApiSceneInstanceEntity;
import io.tiklab.teston.test.apix.http.scene.instance.model.ApiSceneInstanceQuery;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public class ApiSceneInstanceDao {
    private static Logger logger = LoggerFactory.getLogger(ApiSceneInstanceDao.class);
    @Autowired
    JpaTemplate jpaTemplate;

    public String createTestInstance(ApiSceneInstanceEntity testInstanceEntity) {
        return (String)this.jpaTemplate.save((Object)testInstanceEntity, String.class);
    }

    public void updateTestInstance(ApiSceneInstanceEntity testInstanceEntity) {
        this.jpaTemplate.update((Object)testInstanceEntity);
    }

    public void deleteTestInstance(String id) {
        this.jpaTemplate.delete(ApiSceneInstanceEntity.class, (Object)id);
    }

    public void deleteTestInstance(DeleteCondition deleteCondition) {
        this.jpaTemplate.delete(deleteCondition);
    }

    public ApiSceneInstanceEntity findTestInstance(String id) {
        return (ApiSceneInstanceEntity)this.jpaTemplate.findOne(ApiSceneInstanceEntity.class, (Object)id);
    }

    public List<ApiSceneInstanceEntity> findAllTestInstance() {
        return this.jpaTemplate.findAll(ApiSceneInstanceEntity.class);
    }

    public List<ApiSceneInstanceEntity> findTestInstanceList(List<String> idList) {
        return this.jpaTemplate.findList(ApiSceneInstanceEntity.class, idList);
    }

    public List<ApiSceneInstanceEntity> findTestInstanceList(ApiSceneInstanceQuery apiSceneInstanceQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(ApiSceneInstanceEntity.class).eq("apiSceneId", (Object)apiSceneInstanceQuery.getApiSceneId()).orders(apiSceneInstanceQuery.getOrderParams()).get();
        return this.jpaTemplate.findList(queryCondition, ApiSceneInstanceEntity.class);
    }

    public Pagination<ApiSceneInstanceEntity> findTestInstancePage(ApiSceneInstanceQuery apiSceneInstanceQuery) {
        QueryCondition queryCondition = QueryBuilders.createQuery(ApiSceneInstanceEntity.class).eq("apiSceneId", (Object)apiSceneInstanceQuery.getApiSceneId()).orders(apiSceneInstanceQuery.getOrderParams()).pagination(apiSceneInstanceQuery.getPageParam()).get();
        return this.jpaTemplate.findPage(queryCondition, ApiSceneInstanceEntity.class);
    }
}

