/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.scene.execute.service;

import io.tiklab.rpc.client.router.lookup.FixedLookup;
import io.tiklab.rpc.client.router.lookup.Lookup;
import io.tiklab.teston.agent.api.http.scene.ApiSceneTestService;
import io.tiklab.teston.support.agentconfig.model.AgentConfig;
import io.tiklab.teston.support.agentconfig.model.AgentConfigQuery;
import io.tiklab.teston.support.agentconfig.service.AgentConfigService;
import io.tiklab.teston.support.utils.RpcClientApixUtil;
import io.tiklab.teston.test.apix.http.scene.cases.model.ApiSceneStep;
import io.tiklab.teston.test.apix.http.scene.cases.model.ApiSceneStepQuery;
import io.tiklab.teston.test.apix.http.scene.cases.service.ApiSceneStepService;
import io.tiklab.teston.test.apix.http.scene.execute.model.ApiSceneTestRequest;
import io.tiklab.teston.test.apix.http.scene.execute.model.ApiSceneTestResponse;
import io.tiklab.teston.test.apix.http.scene.execute.service.ApiSceneExecuteDispatchService;
import io.tiklab.teston.test.apix.http.scene.instance.model.ApiSceneInstance;
import io.tiklab.teston.test.apix.http.scene.instance.model.ApiSceneInstanceQuery;
import io.tiklab.teston.test.apix.http.scene.instance.service.ApiSceneInstanceService;
import io.tiklab.teston.test.apix.http.unit.cases.model.ApiUnitCase;
import io.tiklab.teston.test.apix.http.unit.cases.model.ApiUnitCaseDataConstruction;
import io.tiklab.teston.test.apix.http.unit.cases.service.ApiUnitCaseService;
import io.tiklab.teston.test.apix.http.unit.execute.model.ApiUnitTestRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class ApiSceneExecuteDispatchServiceImpl
implements ApiSceneExecuteDispatchService {
    static Logger logger = LoggerFactory.getLogger(ApiSceneExecuteDispatchServiceImpl.class);
    @Autowired
    ApiUnitCaseService apiUnitCaseService;
    @Autowired
    ApiSceneStepService apiSceneStepService;
    @Autowired
    ApiSceneInstanceService apiSceneInstanceService;
    @Autowired
    AgentConfigService agentConfigService;
    @Autowired
    RpcClientApixUtil rpcClientApixUtil;
    @Autowired
    ApiSceneTestService apiSceneTestService;
    @Value(value="${teston-agent.embbed.enable:false}")
    Boolean enable;

    ApiSceneTestService apiSceneTestServiceRPC(String agentUrl) {
        return (ApiSceneTestService)this.rpcClientApixUtil.rpcClient().getBean(ApiSceneTestService.class, (Lookup)new FixedLookup(agentUrl));
    }

    public ApiSceneTestResponse execute(ApiSceneTestRequest apiSceneTestRequest) {
        List<ApiUnitTestRequest> apiUnitTestRequestList = this.processApiSceneTestData(apiSceneTestRequest);
        apiSceneTestRequest.setApiUnitTestRequestList(apiUnitTestRequestList);
        ApiSceneTestResponse apiSceneTestResponse = null;
        if (this.enable.booleanValue()) {
            apiSceneTestResponse = this.apiSceneTestService.execute(apiSceneTestRequest);
        } else {
            List agentConfigList = this.agentConfigService.findAgentConfigList(new AgentConfigQuery());
            if (CollectionUtils.isNotEmpty((Collection)agentConfigList)) {
                AgentConfig agentConfig = (AgentConfig)agentConfigList.get(0);
                apiSceneTestResponse = this.apiSceneTestServiceRPC(agentConfig.getUrl()).execute(apiSceneTestRequest);
            }
        }
        if (apiSceneTestRequest.getExeType() == null) {
            String apiSceneId = apiSceneTestRequest.getApiSceneCase().getId();
            this.saveInstance(apiSceneTestResponse, apiSceneId);
        }
        return apiSceneTestResponse;
    }

    public List<ApiUnitTestRequest> processApiSceneTestData(ApiSceneTestRequest apiSceneTestRequest) {
        String apiSceneId = apiSceneTestRequest.getApiSceneCase().getId();
        ApiSceneStepQuery apiSceneStepQuery = new ApiSceneStepQuery();
        apiSceneStepQuery.setApiSceneId(apiSceneId);
        List apiSceneStepList = this.apiSceneStepService.findApiSceneStepList(apiSceneStepQuery);
        ArrayList<ApiUnitTestRequest> apiUnitTestRequestList = new ArrayList<ApiUnitTestRequest>();
        if (CollectionUtils.isNotEmpty((Collection)apiSceneStepList)) {
            for (ApiSceneStep apiSceneStep : apiSceneStepList) {
                ApiUnitTestRequest apiUnitTestRequest = new ApiUnitTestRequest();
                ApiUnitCase apiUnitCase = this.apiUnitCaseService.findApiUnitCase(apiSceneStep.getApiUnit().getId());
                apiUnitTestRequest.setApiUnitCase(apiUnitCase);
                ApiUnitCaseDataConstruction apiUnitCaseDataConstruction = this.apiUnitCaseService.findApiUnitCaseExt(apiUnitCase);
                apiUnitTestRequest.setApiUnitCaseExt(apiUnitCaseDataConstruction);
                apiUnitTestRequest.setApiEnv(apiSceneTestRequest.getApiEnv());
                apiUnitTestRequestList.add(apiUnitTestRequest);
            }
        }
        return apiUnitTestRequestList;
    }

    private void saveInstance(ApiSceneTestResponse apiSceneTestResponse, String apiSceneId) {
        ApiSceneInstance apiSceneInstance = apiSceneTestResponse.getApiSceneInstance();
        apiSceneInstance.setApiSceneId(apiSceneId);
        ApiSceneInstanceQuery apiSceneInstanceQuery = new ApiSceneInstanceQuery();
        apiSceneInstanceQuery.setApiSceneId(apiSceneId);
        List apiSceneInstanceList = this.apiSceneInstanceService.findApiSceneInstanceList(apiSceneInstanceQuery);
        if (apiSceneInstanceList != null && apiSceneInstanceList.size() > 0) {
            Integer executeNumber = ((ApiSceneInstance)apiSceneInstanceList.get(0)).getExecuteNumber();
            executeNumber = executeNumber + 1;
            apiSceneInstance.setExecuteNumber(executeNumber);
        } else {
            apiSceneInstance.setExecuteNumber(Integer.valueOf(1));
        }
        this.apiSceneInstanceService.saveApiSceneInstanceToSql(apiSceneInstance, apiSceneTestResponse);
    }
}

