/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.scene.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.test.apix.http.scene.cases.dao.ApiSceneStepDao;
import io.tiklab.teston.test.apix.http.scene.cases.entity.ApiSceneStepEntity;
import io.tiklab.teston.test.apix.http.scene.cases.model.ApiSceneStep;
import io.tiklab.teston.test.apix.http.scene.cases.model.ApiSceneStepQuery;
import io.tiklab.teston.test.apix.http.scene.cases.service.ApiSceneStepService;
import io.tiklab.teston.test.test.model.TestCase;
import io.tiklab.teston.test.test.service.TestCaseService;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ApiSceneStepServiceImpl
implements ApiSceneStepService {
    @Autowired
    ApiSceneStepDao apiSceneStepDao;
    @Autowired
    TestCaseService testCaseService;
    @Autowired
    JoinTemplate joinTemplate;

    public String createApiSceneStep(@NotNull @Valid ApiSceneStep apiSceneStep) {
        ApiSceneStepEntity apiSceneStepEntity = (ApiSceneStepEntity)BeanMapper.map((Object)apiSceneStep, ApiSceneStepEntity.class);
        apiSceneStepEntity.setCreateTime(new Timestamp(System.currentTimeMillis()));
        return this.apiSceneStepDao.createApiSceneStep(apiSceneStepEntity);
    }

    public void updateApiSceneStep(@NotNull @Valid ApiSceneStep apiSceneStep) {
        ApiSceneStepEntity apiSceneStepEntity = (ApiSceneStepEntity)BeanMapper.map((Object)apiSceneStep, ApiSceneStepEntity.class);
        this.apiSceneStepDao.updateApiSceneStep(apiSceneStepEntity);
    }

    public void deleteApiSceneStep(@NotNull String id) {
        this.apiSceneStepDao.deleteApiSceneStep(id);
    }

    public ApiSceneStep findOne(String id) {
        ApiSceneStepEntity apiSceneStepEntity = this.apiSceneStepDao.findApiSceneStep(id);
        ApiSceneStep apiSceneStep = (ApiSceneStep)BeanMapper.map((Object)apiSceneStepEntity, ApiSceneStep.class);
        return apiSceneStep;
    }

    public List<ApiSceneStep> findList(List<String> idList) {
        List<ApiSceneStepEntity> apiSceneStepEntityList = this.apiSceneStepDao.findApiSceneStepList(idList);
        List apiSceneStepList = BeanMapper.mapList(apiSceneStepEntityList, ApiSceneStep.class);
        return apiSceneStepList;
    }

    public ApiSceneStep findApiSceneStep(@NotNull String id) {
        ApiSceneStep apiSceneStep = this.findOne(id);
        this.joinTemplate.joinQuery((Object)apiSceneStep);
        return apiSceneStep;
    }

    public List<ApiSceneStep> findAllApiSceneStep() {
        List<ApiSceneStepEntity> apiSceneStepEntityList = this.apiSceneStepDao.findAllApiSceneStep();
        List apiSceneStepList = BeanMapper.mapList(apiSceneStepEntityList, ApiSceneStep.class);
        this.joinTemplate.joinQuery(apiSceneStepList);
        return apiSceneStepList;
    }

    public List<ApiSceneStep> findApiSceneStepList(ApiSceneStepQuery apiSceneStepQuery) {
        List<ApiSceneStepEntity> apiSceneStepEntityList = this.apiSceneStepDao.findApiSceneStepList(apiSceneStepQuery);
        List apiSceneStepList = BeanMapper.mapList(apiSceneStepEntityList, ApiSceneStep.class);
        this.joinTemplate.joinQuery(apiSceneStepList);
        ArrayList<ApiSceneStep> arrayList = new ArrayList<ApiSceneStep>();
        if (apiSceneStepList.size() > 0) {
            for (ApiSceneStep apiSceneStep : apiSceneStepList) {
                TestCase testCase = this.testCaseService.findTestCase(apiSceneStep.getApiUnit().getId());
                apiSceneStep.getApiUnit().setTestCase(testCase);
                arrayList.add(apiSceneStep);
            }
        }
        return arrayList;
    }

    public Pagination<ApiSceneStep> findApiSceneStepPage(ApiSceneStepQuery apiSceneStepQuery) {
        Pagination<ApiSceneStepEntity> pagination = this.apiSceneStepDao.findApiSceneStepPage(apiSceneStepQuery);
        List apiSceneStepList = BeanMapper.mapList((List)pagination.getDataList(), ApiSceneStep.class);
        this.joinTemplate.joinQuery(apiSceneStepList);
        return PaginationBuilder.build(pagination, (List)apiSceneStepList);
    }

    public void bindApiUnit(List<ApiSceneStep> apiSceneStepList) {
        for (ApiSceneStep apiSceneStep : apiSceneStepList) {
            this.createApiSceneStep(apiSceneStep);
        }
    }
}

