/*
 * Decompiled with CFR 0.152.
 */
package io.tiklab.teston.test.apix.http.scene.cases.service;

import io.tiklab.beans.BeanMapper;
import io.tiklab.core.page.Pagination;
import io.tiklab.core.page.PaginationBuilder;
import io.tiklab.join.JoinTemplate;
import io.tiklab.teston.category.model.Category;
import io.tiklab.teston.category.service.CategoryService;
import io.tiklab.teston.test.apix.http.scene.cases.dao.ApiSceneCaseDao;
import io.tiklab.teston.test.apix.http.scene.cases.entity.ApiSceneCaseEntity;
import io.tiklab.teston.test.apix.http.scene.cases.model.ApiSceneCase;
import io.tiklab.teston.test.apix.http.scene.cases.model.ApiSceneCaseQuery;
import io.tiklab.teston.test.apix.http.scene.cases.service.ApiSceneCaseService;
import io.tiklab.teston.test.test.model.TestCase;
import io.tiklab.teston.test.test.model.TestCaseQuery;
import io.tiklab.teston.test.test.service.TestCaseService;
import io.tiklab.user.user.model.User;
import io.tiklab.user.user.service.UserService;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.ObjectUtils;

@Service
public class ApiSceneCaseServiceImpl
implements ApiSceneCaseService {
    @Autowired
    ApiSceneCaseDao apiSceneCaseDao;
    @Autowired
    JoinTemplate joinTemplate;
    @Autowired
    TestCaseService testCaseService;
    @Autowired
    CategoryService categoryService;
    @Autowired
    UserService userService;

    public String createApiSceneCase(@NotNull @Valid ApiSceneCase apiSceneCase) {
        ApiSceneCaseEntity apiSceneCaseEntity = (ApiSceneCaseEntity)BeanMapper.map((Object)apiSceneCase, ApiSceneCaseEntity.class);
        String id = this.apiSceneCaseDao.createApiSceneCase(apiSceneCaseEntity);
        apiSceneCaseEntity.setTestCaseId(id);
        apiSceneCaseEntity.setId(id);
        this.apiSceneCaseDao.updateApiSceneCase(apiSceneCaseEntity);
        TestCase testCase = apiSceneCase.getTestCase();
        testCase.setId(id);
        this.testCaseService.createTestCase(testCase);
        return id;
    }

    public void updateApiSceneCase(@NotNull @Valid ApiSceneCase apiSceneCase) {
        ApiSceneCaseEntity apiSceneCaseEntity = (ApiSceneCaseEntity)BeanMapper.map((Object)apiSceneCase, ApiSceneCaseEntity.class);
        apiSceneCaseEntity.setTestCaseId(apiSceneCase.getId());
        this.apiSceneCaseDao.updateApiSceneCase(apiSceneCaseEntity);
        this.testCaseService.updateTestCase(apiSceneCase.getTestCase());
    }

    public void deleteApiSceneCase(@NotNull String id) {
        this.apiSceneCaseDao.deleteApiSceneCase(id);
        this.testCaseService.deleteTestCase(id);
    }

    public ApiSceneCase findOne(String id) {
        ApiSceneCaseEntity apiSceneCaseEntity = this.apiSceneCaseDao.findApiSceneCase(id);
        ApiSceneCase apiSceneCase = (ApiSceneCase)BeanMapper.map((Object)apiSceneCaseEntity, ApiSceneCase.class);
        this.joinTemplate.joinQuery((Object)apiSceneCase);
        return apiSceneCase;
    }

    public List<ApiSceneCase> findList(List<String> idList) {
        List<ApiSceneCaseEntity> apiSceneCaseEntityList = this.apiSceneCaseDao.findApiSceneCaseList(idList);
        List apiSceneCaseList = BeanMapper.mapList(apiSceneCaseEntityList, ApiSceneCase.class);
        return apiSceneCaseList;
    }

    public ApiSceneCase findApiSceneCase(@NotNull String id) {
        ApiSceneCase apiSceneCase = this.findOne(id);
        this.joinTemplate.joinQuery((Object)apiSceneCase);
        TestCase testCase = apiSceneCase.getTestCase();
        if (testCase.getCategory() != null) {
            Category category = this.categoryService.findCategory(testCase.getCategory().getId());
            apiSceneCase.getTestCase().setCategory(category);
        }
        if (testCase.getUpdateUser() != null) {
            User updateUser = this.userService.findUser(testCase.getUpdateUser().getId());
            apiSceneCase.getTestCase().setUpdateUser(updateUser);
        }
        return apiSceneCase;
    }

    public List<ApiSceneCase> findAllApiSceneCase() {
        List<ApiSceneCaseEntity> apiSceneCaseEntityList = this.apiSceneCaseDao.findAllApiSceneCase();
        List apiSceneCaseList = BeanMapper.mapList(apiSceneCaseEntityList, ApiSceneCase.class);
        this.joinTemplate.joinQuery(apiSceneCaseList);
        return apiSceneCaseList;
    }

    public List<ApiSceneCase> findApiSceneCaseList(ApiSceneCaseQuery apiSceneCaseQuery) {
        List<ApiSceneCaseEntity> apiSceneCaseEntityList = this.apiSceneCaseDao.findApiSceneCaseList(apiSceneCaseQuery);
        List apiSceneCaseList = BeanMapper.mapList(apiSceneCaseEntityList, ApiSceneCase.class);
        this.joinTemplate.joinQuery(apiSceneCaseList);
        return apiSceneCaseList;
    }

    public List<ApiSceneCase> findApiSceneCaseListByTestCase(TestCaseQuery testCaseQuery) {
        List testCaseList = this.testCaseService.findTestCaseList(testCaseQuery);
        ArrayList<ApiSceneCase> apiSceneCaseList = new ArrayList<ApiSceneCase>();
        if (!ObjectUtils.isEmpty((Object)testCaseList)) {
            for (TestCase testcase : testCaseList) {
                ApiSceneCase apiSceneCase = this.findApiSceneCase(testcase.getId());
                apiSceneCaseList.add(apiSceneCase);
            }
        }
        return apiSceneCaseList;
    }

    public Pagination<ApiSceneCase> findApiSceneCasePage(ApiSceneCaseQuery apiSceneCaseQuery) {
        Pagination<ApiSceneCaseEntity> pagination = this.apiSceneCaseDao.findApiSceneCasePage(apiSceneCaseQuery);
        List apiSceneCaseList = BeanMapper.mapList((List)pagination.getDataList(), ApiSceneCase.class);
        this.joinTemplate.joinQuery(apiSceneCaseList);
        return PaginationBuilder.build(pagination, (List)apiSceneCaseList);
    }
}

